/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.ArrayDeque;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentReferenceCleaner
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ParentReferenceCleaner.class);

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)new ParentFixingVisitor());
    }

    private class ParentFixingVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final ArrayDeque<QueryModelNode> ancestors = new ArrayDeque();

        private ParentFixingVisitor() {
        }

        protected void meetNode(QueryModelNode node) throws RuntimeException {
            QueryModelNode expectedParent = this.ancestors.peekLast();
            if (node.getParentNode() != expectedParent) {
                logger.debug("unexpected parent for node {}: {} (expected {})", new Object[]{node, node.getParentNode(), expectedParent});
                node.setParentNode(expectedParent);
            }
            this.ancestors.addLast(node);
            super.meetNode(node);
            this.ancestors.pollLast();
        }
    }
}

