/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;

public class StatementPatternQueryEvaluationStep
implements QueryEvaluationStep {
    private final StatementPattern statementPattern;
    private final TripleSource tripleSource;
    private final boolean emptyGraph;
    private final Function<Value, Resource[]> contextSup;
    private final BiConsumer<MutableBindingSet, Statement> converter;
    private final QueryEvaluationContext context;
    private final Predicate<BindingSet> unboundTest;
    private final Function<BindingSet, Value> getContextVar;
    private final Function<BindingSet, Value> getSubjectVar;
    private final Function<BindingSet, Value> getPredicateVar;
    private final Function<BindingSet, Value> getObjectVar;

    public StatementPatternQueryEvaluationStep(StatementPattern statementPattern, QueryEvaluationContext context, TripleSource tripleSource) {
        this.statementPattern = statementPattern;
        this.context = context;
        this.tripleSource = tripleSource;
        Set graphs = null;
        Dataset dataset = context.getDataset();
        this.emptyGraph = dataset != null ? (statementPattern.getScope() == StatementPattern.Scope.DEFAULT_CONTEXTS ? (graphs = dataset.getDefaultGraphs()).isEmpty() && !dataset.getNamedGraphs().isEmpty() : (graphs = dataset.getNamedGraphs()).isEmpty() && !dataset.getDefaultGraphs().isEmpty()) : false;
        this.contextSup = StatementPatternQueryEvaluationStep.extractContextsFromDatasets(statementPattern.getContextVar(), this.emptyGraph, graphs);
        this.converter = StatementPatternQueryEvaluationStep.makeConverter(context, statementPattern);
        Var subjVar = statementPattern.getSubjectVar();
        Var predVar = statementPattern.getPredicateVar();
        Var objVar = statementPattern.getObjectVar();
        Var conVar = statementPattern.getContextVar();
        Predicate<BindingSet> isSubjBound = StatementPatternQueryEvaluationStep.unbound(subjVar, context);
        Predicate<BindingSet> isPredBound = StatementPatternQueryEvaluationStep.unbound(predVar, context);
        Predicate<BindingSet> isObjBound = StatementPatternQueryEvaluationStep.unbound(objVar, context);
        Predicate<BindingSet> isConBound = StatementPatternQueryEvaluationStep.unbound(conVar, context);
        Predicate<BindingSet> isNotEmpty = Predicate.not(BindingSet::isEmpty);
        this.unboundTest = isNotEmpty.and(isSubjBound.or(isPredBound).or(isObjBound).or(isConBound));
        this.getContextVar = StatementPatternQueryEvaluationStep.makeGetVarValue(conVar, context);
        this.getSubjectVar = StatementPatternQueryEvaluationStep.makeGetVarValue(subjVar, context);
        this.getPredicateVar = StatementPatternQueryEvaluationStep.makeGetVarValue(predVar, context);
        this.getObjectVar = StatementPatternQueryEvaluationStep.makeGetVarValue(objVar, context);
    }

    private static Function<BindingSet, Value> makeGetVarValue(Var var, QueryEvaluationContext context) {
        if (var == null) {
            return b -> null;
        }
        if (var.hasValue()) {
            Value value = var.getValue();
            return b -> value;
        }
        return context.getValue(var.getName());
    }

    private static Predicate<BindingSet> unbound(Var var, QueryEvaluationContext context) {
        if (var == null) {
            return bindings -> false;
        }
        Predicate<BindingSet> hasBinding = context.hasBinding(var.getName());
        Function<BindingSet, Value> getValue = context.getValue(var.getName());
        Predicate<BindingSet> getBindingIsNull = binding -> getValue.apply((BindingSet)binding) == null;
        return hasBinding.and(getBindingIsNull);
    }

    private static BiConsumer<Value, MutableBindingSet> makeSetVariable(Var var, QueryEvaluationContext context) {
        if (var == null) {
            return null;
        }
        return context.addBinding(var.getName());
    }

    private static Predicate<BindingSet> makeIsVariableNotSet(Var var, QueryEvaluationContext context) {
        if (var == null) {
            return bindings -> true;
        }
        return Predicate.not(context.hasBinding(var.getName()));
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
        IRI predIri;
        Resource subjResouce;
        if (this.emptyGraph) {
            return new EmptyIteration();
        }
        if (this.unboundTest.test(bindings)) {
            return new EmptyIteration();
        }
        Value contextValue = this.getContextVar.apply(bindings);
        Resource[] contexts = this.contextSup.apply(contextValue);
        if (contexts == null) {
            return new EmptyIteration();
        }
        Value subjValue = this.getSubjectVar.apply(bindings);
        Value predValue = this.getPredicateVar.apply(bindings);
        try {
            subjResouce = (Resource)subjValue;
            predIri = (IRI)predValue;
        }
        catch (ClassCastException e) {
            return new EmptyIteration();
        }
        return this.evaluateTheNormalCase(bindings, contexts, subjValue, predValue, subjResouce, predIri);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluateTheNormalCase(BindingSet bindings, Resource[] contexts, Value subjValue, Value predValue, Resource subjResouce, IRI predIri) {
        Value objValue = this.getObjectVar.apply(bindings);
        Object stIter1 = this.tripleSource.getStatements(subjResouce, predIri, objValue, contexts);
        final Predicate<Statement> filter = StatementPatternQueryEvaluationStep.filterContextOrEqualVariables(this.statementPattern, subjValue, predValue, objValue, contexts);
        if (filter != null) {
            stIter1 = new FilterIteration<Statement, QueryEvaluationException>(stIter1){

                protected boolean accept(Statement object) throws QueryEvaluationException {
                    return filter.test(object);
                }
            };
        }
        return new ConvertStatmentToBindingSetIterator((Iteration<? extends Statement, ? extends QueryEvaluationException>)stIter1, this.converter, bindings, this.context);
    }

    protected static Predicate<Statement> filterContextOrEqualVariables(StatementPattern statementPattern, Value subjValue, Value predValue, Value objValue, Resource[] contexts) {
        Predicate<Statement> filter = null;
        if (contexts.length == 0 && statementPattern.getScope() == StatementPattern.Scope.NAMED_CONTEXTS) {
            filter = st -> st.getContext() != null;
        }
        return StatementPatternQueryEvaluationStep.filterSameVariable(statementPattern, subjValue, predValue, objValue, filter);
    }

    private static Predicate<Statement> filterSameVariable(StatementPattern statementPattern, Value subjValue, Value predValue, Value objValue, Predicate<Statement> filter) {
        boolean objEqConVar;
        Var subjVar = statementPattern.getSubjectVar();
        Var predVar = statementPattern.getPredicateVar();
        Var objVar = statementPattern.getObjectVar();
        Var conVar = statementPattern.getContextVar();
        if (subjVar != null && subjValue == null) {
            boolean subEqPredVar = subjVar.equals((Object)predVar);
            boolean subEqObjVar = subjVar.equals((Object)objVar);
            boolean subEqConVar = subjVar.equals((Object)conVar);
            if (subEqPredVar || subEqObjVar || subEqConVar) {
                filter = StatementPatternQueryEvaluationStep.andThen(filter, StatementPatternQueryEvaluationStep.subjectVariableHasEquals(subEqPredVar, subEqObjVar, subEqConVar));
            }
        }
        if (predVar != null && predValue == null) {
            boolean predEqObjVar = predVar.equals((Object)objVar);
            boolean predEqConVar = predVar.equals((Object)conVar);
            if (predEqObjVar || predEqConVar) {
                filter = StatementPatternQueryEvaluationStep.andThen(filter, StatementPatternQueryEvaluationStep.predicateVariableHasEquals(predEqObjVar, predEqConVar));
            }
        }
        if (objVar != null && objValue == null && (objEqConVar = objVar.equals((Object)conVar))) {
            filter = StatementPatternQueryEvaluationStep.andThen(filter, (Statement st) -> {
                Value obj = st.getObject();
                Resource context = st.getContext();
                return obj.equals(context);
            });
        }
        return filter;
    }

    private static Predicate<Statement> predicateVariableHasEquals(boolean predEqObjVar, boolean predEqConVar) {
        Predicate<Statement> eq = null;
        if (predEqObjVar) {
            eq = st -> st.getPredicate().equals((Object)st.getObject());
        }
        if (predEqConVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, (Statement st) -> st.getPredicate().equals((Object)st.getContext()));
        }
        return eq;
    }

    private static Predicate<Statement> subjectVariableHasEquals(boolean subEqPredVar, boolean subEqObjVar, boolean subEqConVar) {
        Predicate<Statement> eq = null;
        if (subEqPredVar) {
            eq = st -> st.getSubject().equals(st.getPredicate());
        }
        if (subEqObjVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, (Statement st) -> st.getSubject().equals(st.getObject()));
        }
        if (subEqConVar) {
            eq = StatementPatternQueryEvaluationStep.andThen(eq, (Statement st) -> st.getSubject().equals(st.getContext()));
        }
        return eq;
    }

    protected static Function<Value, Resource[]> extractContextsFromDatasets(Var contextVar, boolean emptyGraph, Set<IRI> graphs) {
        if (emptyGraph) {
            return cv -> null;
        }
        if (graphs == null || graphs.isEmpty()) {
            return contextValue -> StatementPatternQueryEvaluationStep.contextsGivenContextVal(contextValue);
        }
        Resource[] filled = StatementPatternQueryEvaluationStep.fillContextsFromDatasSetGraphs(graphs);
        if (contextVar == null) {
            return contextValue -> filled;
        }
        return contextValue -> {
            if (contextValue != null) {
                if (graphs.contains(contextValue)) {
                    return new Resource[]{(Resource)contextValue};
                }
                return null;
            }
            return filled;
        };
    }

    private static Resource[] contextsGivenContextVal(Value contextValue) {
        if (contextValue != null) {
            if (RDF4J.NIL.equals((Object)contextValue) || SESAME.NIL.equals((Object)contextValue)) {
                return new Resource[]{null};
            }
            return new Resource[]{(Resource)contextValue};
        }
        return new Resource[0];
    }

    private static Resource[] fillContextsFromDatasSetGraphs(Set<IRI> graphs) {
        Resource[] contexts = new Resource[graphs.size()];
        int i = 0;
        for (IRI graph : graphs) {
            IRI context = null;
            if (!RDF4J.NIL.equals((Object)graph) && !SESAME.NIL.equals((Object)graph)) {
                context = graph;
            }
            contexts[i++] = context;
        }
        return contexts;
    }

    private static BiConsumer<MutableBindingSet, Statement> makeConverter(QueryEvaluationContext context, StatementPattern statementPattern) {
        Var subjVar = statementPattern.getSubjectVar();
        Var predVar = statementPattern.getPredicateVar();
        Var objVar = statementPattern.getObjectVar();
        Var conVar = statementPattern.getContextVar();
        BiConsumer<MutableBindingSet, Statement> co = null;
        if (subjVar != null && !subjVar.isConstant()) {
            BiConsumer<Value, MutableBindingSet> setSubject = StatementPatternQueryEvaluationStep.makeSetVariable(subjVar, context);
            Predicate<BindingSet> subjectIsNotSet = StatementPatternQueryEvaluationStep.makeIsVariableNotSet(subjVar, context);
            co = StatementPatternQueryEvaluationStep.andThen(co, (MutableBindingSet result, Statement st) -> StatementPatternQueryEvaluationStep.addValueToBinding(result, (Value)st.getSubject(), subjectIsNotSet, setSubject));
        }
        if (predVar != null && !predVar.isConstant() && !predVar.equals((Object)subjVar)) {
            BiConsumer<Value, MutableBindingSet> setPredicate = StatementPatternQueryEvaluationStep.makeSetVariable(predVar, context);
            Predicate<BindingSet> predicateIsNotSet = StatementPatternQueryEvaluationStep.makeIsVariableNotSet(predVar, context);
            co = StatementPatternQueryEvaluationStep.andThen(co, (MutableBindingSet result, Statement st) -> StatementPatternQueryEvaluationStep.addValueToBinding(result, (Value)st.getPredicate(), predicateIsNotSet, setPredicate));
        }
        if (!(objVar == null || objVar.isConstant() || objVar.equals((Object)subjVar) || objVar.equals((Object)predVar))) {
            BiConsumer<Value, MutableBindingSet> setObject = StatementPatternQueryEvaluationStep.makeSetVariable(objVar, context);
            Predicate<BindingSet> objectIsNotSet = StatementPatternQueryEvaluationStep.makeIsVariableNotSet(objVar, context);
            co = StatementPatternQueryEvaluationStep.andThen(co, (MutableBindingSet result, Statement st) -> StatementPatternQueryEvaluationStep.addValueToBinding(result, st.getObject(), objectIsNotSet, setObject));
        }
        if (!(conVar == null || conVar.isConstant() || conVar.equals((Object)subjVar) || conVar.equals((Object)predVar) || conVar.equals((Object)objVar))) {
            BiConsumer<Value, MutableBindingSet> setContext = StatementPatternQueryEvaluationStep.makeSetVariable(conVar, context);
            Predicate<BindingSet> contextIsNotSet = StatementPatternQueryEvaluationStep.makeIsVariableNotSet(conVar, context);
            co = StatementPatternQueryEvaluationStep.andThen(co, (MutableBindingSet result, Statement st) -> {
                if (st.getContext() != null) {
                    StatementPatternQueryEvaluationStep.addValueToBinding(result, (Value)st.getContext(), contextIsNotSet, setContext);
                }
            });
        }
        if (co == null) {
            return (result, st) -> {};
        }
        return co;
    }

    private static void addValueToBinding(MutableBindingSet result, Value value, Predicate<BindingSet> varIsNotSet, BiConsumer<Value, MutableBindingSet> setVal) {
        if (varIsNotSet.test((BindingSet)result)) {
            setVal.accept(value, result);
        }
    }

    private static Predicate<Statement> andThen(Predicate<Statement> pred, Predicate<Statement> and) {
        if (pred == null) {
            return and;
        }
        return pred.and(and);
    }

    private static BiConsumer<MutableBindingSet, Statement> andThen(BiConsumer<MutableBindingSet, Statement> co, BiConsumer<MutableBindingSet, Statement> and) {
        if (co == null) {
            return and;
        }
        return co.andThen(and);
    }

    private static final class ConvertStatmentToBindingSetIterator
    extends ConvertingIteration<Statement, BindingSet, QueryEvaluationException> {
        private final Function<Statement, MutableBindingSet> convertingFunction;

        private ConvertStatmentToBindingSetIterator(Iteration<? extends Statement, ? extends QueryEvaluationException> iter, BiConsumer<MutableBindingSet, Statement> action, BindingSet bindings, QueryEvaluationContext context) {
            super(iter);
            this.convertingFunction = bindings.isEmpty() ? st -> {
                MutableBindingSet made = context.createBindingSet();
                action.accept(made, (Statement)st);
                return made;
            } : st -> {
                MutableBindingSet made = context.createBindingSet(bindings);
                action.accept(made, (Statement)st);
                return made;
            };
        }

        protected BindingSet convert(Statement st) {
            return (BindingSet)this.convertingFunction.apply(st);
        }
    }
}

