/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LimitIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;
    private final long limit;
    private final boolean distinct;
    private final List<SerializedQueue<BindingSet>> serialized = new LinkedList<SerializedQueue<BindingSet>>();
    private final long iterationSyncThreshold;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this(iter, comparator, Long.MAX_VALUE, false);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct) {
        this(iter, comparator, limit, distinct, Integer.MAX_VALUE);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator, long limit, boolean distinct, long iterationSyncThreshold) {
        this.iter = iter;
        this.comparator = comparator;
        this.limit = limit;
        this.distinct = distinct;
        this.iterationSyncThreshold = iterationSyncThreshold > 0L ? iterationSyncThreshold : Integer.MAX_VALUE;
    }

    @Override
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        BindingSet threshold = null;
        AbstractList list = new LinkedList<BindingSet>();
        int limit2 = this.limit >= 0x3FFFFFFFL ? Integer.MAX_VALUE : (int)this.limit * 2;
        int syncThreshold = (int)Math.min(this.iterationSyncThreshold, Integer.MAX_VALUE);
        try {
            while (this.iter.hasNext()) {
                if (list.size() >= syncThreshold && (long)list.size() < this.limit) {
                    SerializedQueue queue = new SerializedQueue("orderiter");
                    this.sort(list).forEach(queue::add);
                    this.serialized.add(queue);
                    this.decrement(list.size() - queue.size());
                    list = new ArrayList(list.size());
                    if (threshold == null && this.serialized.stream().mapToLong(SerializedQueue::size).sum() >= this.limit) {
                        Stream<BindingSet> stream = this.serialized.stream().map(SerializedQueue::peekLast);
                        threshold = stream.sorted(this.comparator).skip(this.serialized.size() - 1).findFirst().orElseThrow();
                    }
                } else if (list.size() >= limit2 || !this.distinct && threshold == null && (long)list.size() >= this.limit) {
                    ArrayList sorted = new ArrayList(limit2);
                    this.sort(list).forEach(sorted::add);
                    this.decrement(list.size() - sorted.size());
                    list = sorted;
                    if ((long)sorted.size() >= this.limit) {
                        threshold = (BindingSet)sorted.get(sorted.size() - 1);
                    }
                }
                BindingSet next = (BindingSet)this.iter.next();
                if (threshold != null && this.comparator.compare(next, threshold) >= 0) continue;
                list.add((BindingSet)next);
                this.increment();
            }
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            this.iter.close();
        }
        ArrayList iterators = new ArrayList(this.serialized.size() + 1);
        this.serialized.stream().map(SerializedQueue::iterator).forEach(iterators::add);
        iterators.add(this.sort(list).iterator());
        SortedIterators<BindingSet> iterator = new SortedIterators<BindingSet>(this.comparator, this.distinct, iterators);
        return new LimitIteration<BindingSet, QueryEvaluationException>(new CloseableIteratorIteration(iterator), this.limit);
    }

    protected void increment() throws QueryEvaluationException {
    }

    protected void decrement(int amount) throws QueryEvaluationException {
    }

    private Stream<BindingSet> sort(Collection<BindingSet> collection) {
        BindingSet[] array = collection.toArray(new BindingSet[collection.size()]);
        Arrays.parallelSort(array, this.comparator);
        Stream<BindingSet> stream = Stream.of(array);
        if (this.distinct) {
            stream = stream.distinct();
        }
        if (this.limit < Integer.MAX_VALUE) {
            stream = stream.limit(this.limit);
        }
        return stream;
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.iter.close();
            }
            finally {
                this.serialized.stream().map(queue -> {
                    try {
                        queue.close();
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }).filter(exec -> exec != null).findFirst().ifPresent(exec -> {
                    throw new QueryEvaluationException((Throwable)exec);
                });
            }
        }
    }

    private static class SortedIterators<E>
    implements Iterator<E> {
        private final List<Iterator<E>> iterators;
        private final TreeMap<E, List<Integer>> head;
        private final boolean distinct;
        private E next;

        public SortedIterators(Comparator<E> comparator, boolean distinct, List<Iterator<E>> iterators) {
            this.iterators = iterators;
            this.distinct = distinct;
            this.head = new TreeMap(comparator);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.next();
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                try {
                    E e = this.next;
                    return e;
                }
                finally {
                    this.next = null;
                }
            }
            if (this.head.isEmpty()) {
                int n = this.iterators.size();
                for (int i = 0; i < n; ++i) {
                    this.advance(i);
                }
            }
            if (this.head.isEmpty()) {
                return null;
            }
            Map.Entry<E, List<Integer>> e = this.head.firstEntry();
            this.advance(e.getValue().remove(0));
            if (e.getValue().isEmpty()) {
                this.head.remove(e.getKey());
            }
            return e.getKey();
        }

        private void advance(int i) {
            while (this.iterators.get(i).hasNext()) {
                E key = this.iterators.get(i).next();
                if (!this.head.containsKey(key)) {
                    this.head.put(key, new LinkedList<Integer>(Arrays.asList(i)));
                    break;
                }
                if (this.distinct) continue;
                this.head.get(key).add(i);
                break;
            }
        }
    }

    private static class SerializedQueue<E extends Serializable>
    extends AbstractQueue<E>
    implements Closeable {
        private final File file;
        private final ObjectOutputStream output;
        private ObjectInputStream input;
        private int size;
        private E next;
        private E last;

        public SerializedQueue(String prefix) throws IOException {
            this(prefix, null);
        }

        public SerializedQueue(String prefix, File directory) throws IOException {
            this.file = File.createTempFile(prefix, "", directory);
            this.output = new ObjectOutputStream(new FileOutputStream(this.file));
        }

        public E peekLast() {
            return this.last;
        }

        @Override
        public boolean offer(E e) {
            if (this.output == null) {
                return false;
            }
            try {
                this.output.writeObject(e);
                this.last = e;
                ++this.size;
                return true;
            }
            catch (IOException exc) {
                return false;
            }
        }

        @Override
        public E poll() {
            try {
                if (this.next != null) {
                    E e = this.next;
                    return e;
                }
                if (this.input == null) {
                    this.output.close();
                    this.input = new ObjectInputStream(new FileInputStream(this.file));
                }
                --this.size;
                Serializable serializable = (Serializable)this.input.readObject();
                return (E)serializable;
            }
            catch (IOException | ClassNotFoundException exc) {
                E e = null;
                return e;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public E peek() {
            if (this.size <= 0) {
                return null;
            }
            if (this.next != null) {
                return this.next;
            }
            this.next = this.poll();
            return this.next;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return this.peek() != null;
                }

                @Override
                public E next() {
                    return this.poll();
                }
            };
        }

        @Override
        public int size() {
            if (this.next == null) {
                return this.size;
            }
            return this.size + 1;
        }

        @Override
        public void close() throws IOException {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            this.file.delete();
        }
    }
}

