/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SimpleBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public abstract class AbstractBulkJoinPlanNode
implements PlanNode {
    protected Function<BindingSet, ValidationTuple> mapper;
    ValidationExecutionLogger validationExecutionLogger;

    ParsedQuery parseQuery(String query) {
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
        query = query.replace("#VALUES_INJECTION_POINT#", "\nVALUES (?a) {}\n");
        String completeQuery = "select * where { \nVALUES (?a) {}\n" + query + "\n}\nORDER BY ?a";
        return queryParserFactory.getParser().parseQuery(completeQuery, null);
    }

    void runQuery(ArrayDeque<ValidationTuple> left, ArrayDeque<ValidationTuple> right, SailConnection connection, ParsedQuery parsedQuery, Dataset dataset, Resource[] dataGraph, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Function<BindingSet, ValidationTuple> mapper) {
        List<BindingSet> newBindindingset = this.buildBindingSets(left, connection, skipBasedOnPreviousConnection, previousStateConnection, dataGraph);
        if (!newBindindingset.isEmpty()) {
            this.updateQuery(parsedQuery, newBindindingset);
            AbstractBulkJoinPlanNode.executeQuery(right, connection, dataset, parsedQuery, mapper);
        }
    }

    private static void executeQuery(ArrayDeque<ValidationTuple> right, SailConnection connection, Dataset dataset, ParsedQuery parsedQuery, Function<BindingSet, ValidationTuple> mapper) {
        try (Stream stream = connection.evaluate(parsedQuery.getTupleExpr(), dataset, (BindingSet)new MapBindingSet(), true).stream();){
            stream.map(mapper).forEachOrdered(right::addFirst);
        }
    }

    private void updateQuery(ParsedQuery parsedQuery, final List<BindingSet> newBindindingset) {
        try {
            parsedQuery.getTupleExpr().visit((QueryModelVisitor)new AbstractQueryModelVisitor<Exception>(){

                public void meet(BindingSetAssignment node) throws Exception {
                    Set bindingNames = node.getBindingNames();
                    if (bindingNames.size() == 1 && bindingNames.contains("a")) {
                        node.setBindingSets((Iterable)newBindindingset);
                    }
                    super.meet(node);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<BindingSet> buildBindingSets(ArrayDeque<ValidationTuple> left, SailConnection connection, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Resource[] dataGraph) {
        return left.stream().filter(tuple -> {
            boolean hasStatement;
            if (!skipBasedOnPreviousConnection) {
                return true;
            }
            if (!tuple.getActiveTarget().isResource()) {
                hasStatement = previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            } else {
                boolean bl = hasStatement = previousStateConnection.hasStatement((Resource)tuple.getActiveTarget(), null, null, true, dataGraph) || previousStateConnection.hasStatement(null, null, tuple.getActiveTarget(), true, dataGraph);
            }
            if (!hasStatement && this.validationExecutionLogger.isEnabled()) {
                this.validationExecutionLogger.log(this.depth(), this.getClass().getSimpleName() + ":IgnoredDueToPreviousStateConnection", (ValidationTuple)tuple, this, this.getId(), null);
            }
            return hasStatement;
        }).map(ValidationTuple::getActiveTarget).map(r -> new SimpleBindingSet(Collections.singleton("a"), Collections.singletonList("a"), Collections.singletonList(r))).collect(Collectors.toList());
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBulkJoinPlanNode that = (AbstractBulkJoinPlanNode)o;
        return this.mapper.equals(that.mapper);
    }

    public int hashCode() {
        return Objects.hash(this.mapper);
    }
}

