/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iterator.Iterators;

public class CloseableIterationIterator<E>
implements Iterator<E>,
Closeable {
    private final Iteration<? extends E, ? extends RuntimeException> iteration;

    public CloseableIterationIterator(Iteration<? extends E, ? extends RuntimeException> iteration) {
        this.iteration = iteration;
    }

    @Override
    public boolean hasNext() {
        boolean hasMore = this.iteration.hasNext();
        if (!hasMore) {
            Iterators.closeSilently(this);
        }
        return hasMore;
    }

    @Override
    public E next() {
        return this.iteration.next();
    }

    @Override
    public void remove() {
        this.iteration.remove();
    }

    @Override
    public void close() throws IOException {
        Iterations.closeCloseable(this.iteration);
    }
}

