/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class RepositoryConnectionShapeSource
implements ShapeSource {
    private final RepositoryConnection connection;
    private final Resource[] context;

    public RepositoryConnectionShapeSource(RepositoryConnection connection) {
        this(connection, null);
    }

    private RepositoryConnectionShapeSource(RepositoryConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        assert (connection.isActive());
    }

    @Override
    public RepositoryConnectionShapeSource withContext(Resource[] context) {
        return new RepositoryConnectionShapeSource(this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        assert (this.context == null);
        try (Stream stream = this.connection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, new Resource[0]).stream();){
            Stream<ShapeSource.ShapesGraph> stream2 = stream.collect(Collectors.groupingBy(Statement::getSubject)).entrySet().stream().map(entry -> new ShapeSource.ShapesGraph((Resource)entry.getKey(), (List)entry.getValue()));
            return stream2;
        }
    }

    private Stream<Resource> getContext(ShapeSource.Predicates predicate) {
        assert (this.context == null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, new Resource[0]).stream().map(Statement::getContext).distinct();
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape)).reduce(Stream::concat).get().distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        return this.connection.hasStatement(subject, RDF.TYPE, (Value)type, true, this.context);
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return this.connection.getStatements(id, null, null, true, this.context).stream();
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        assert (this.context != null);
        return this.connection.getStatements(subject, RDF.FIRST, null, true, this.context).stream().map(Statement::getObject).findAny().orElse(null);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        assert (this.context != null);
        Value value = this.connection.getStatements(subject, RDF.REST, null, true, this.context).stream().map(Statement::getObject).findAny().orElse(null);
        return (Resource)value;
    }

    @Override
    public void close() {
    }
}

