/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;

public abstract class LookAheadIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private E nextElement;

    protected LookAheadIteration() {
    }

    protected abstract E getNextElement() throws X;

    @Override
    public final boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        return this.lookAhead() != null;
    }

    @Override
    public final E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        E result = this.lookAhead();
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private E lookAhead() throws X {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                this.close();
            }
        }
        return this.nextElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            this.nextElement = null;
        }
    }
}

