/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.ast;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.rdf4j.query.parser.sparql.ast.JavaCharStream;

public class UnicodeEscapeStream
extends JavaCharStream {
    public UnicodeEscapeStream(Reader dstream, int tabSize) {
        super(dstream);
        this.setTabSize(tabSize);
    }

    @Override
    public char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        if (++this.bufpos == this.available) {
            this.AdjustBuffSize();
        }
        this.buffer[this.bufpos] = c = this.ReadByte();
        if (c == '\\') {
            this.UpdateLineColumn(c);
            int backSlashCnt = 1;
            while (true) {
                if (++this.bufpos == this.available) {
                    this.AdjustBuffSize();
                }
                try {
                    this.buffer[this.bufpos] = c = this.ReadByte();
                    if (c != '\\') {
                        this.UpdateLineColumn(c);
                        if ((c == 'u' || c == 'U') && (backSlashCnt & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.bufsize - 1;
                            break;
                        }
                        this.backup(backSlashCnt);
                        return '\\';
                    }
                }
                catch (IOException e) {
                    if (backSlashCnt > 1) {
                        this.backup(backSlashCnt - 1);
                    }
                    return '\\';
                }
                this.UpdateLineColumn(c);
                ++backSlashCnt;
            }
            try {
                if (c == 'u') {
                    this.buffer[this.bufpos] = c = (char)(UnicodeEscapeStream.hexval(this.ReadByte()) << 12 | UnicodeEscapeStream.hexval(this.ReadByte()) << 8 | UnicodeEscapeStream.hexval(this.ReadByte()) << 4 | UnicodeEscapeStream.hexval(this.ReadByte()));
                    this.column += 4;
                } else if (c == 'U') {
                    String hex = new String(new char[]{this.ReadByte(), this.ReadByte(), this.ReadByte(), this.ReadByte(), this.ReadByte(), this.ReadByte(), this.ReadByte(), this.ReadByte()});
                    int cp = Integer.parseInt(hex, 16);
                    char[] chrs = Character.toChars(cp);
                    this.buffer[this.bufpos] = c = chrs[0];
                    if (chrs.length > 1) {
                        if (++this.bufpos == this.available) {
                            this.AdjustBuffSize();
                        }
                        this.buffer[this.bufpos] = chrs[1];
                        this.UpdateLineColumn(c);
                        this.backup(1);
                    }
                    this.column += hex.length();
                }
            }
            catch (IOException | IllegalArgumentException e) {
                throw new Error("Invalid escape character at line " + this.line + " column " + this.column + ".", e);
            }
            if (backSlashCnt == 1) {
                return c;
            }
            this.backup(backSlashCnt - 1);
            return '\\';
        }
        this.UpdateLineColumn(c);
        return c;
    }
}

