/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryPattern;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.TriplesTemplate;
import org.eclipse.rdf4j.sparqlbuilder.core.query.UpdateQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public class ModifyQuery
extends UpdateQuery<ModifyQuery> {
    private static final String INSERT = "INSERT";
    private static final String DELETE = "DELETE";
    private static final String WITH = "WITH";
    private static final String USING = "USING";
    private static final String NAMED = "NAMED";
    private Optional<Iri> with = Optional.empty();
    private Optional<Iri> using = Optional.empty();
    private boolean usingNamed = false;
    private Optional<TriplesTemplate> deleteTriples = Optional.empty();
    private Optional<TriplesTemplate> insertTriples = Optional.empty();
    private Optional<GraphName> deleteGraph = Optional.empty();
    private Optional<GraphName> insertGraph = Optional.empty();
    private QueryPattern where = SparqlBuilder.where(new GraphPattern[0]);

    ModifyQuery() {
    }

    public ModifyQuery with(Iri iri) {
        this.with = Optional.ofNullable(iri);
        return this;
    }

    public ModifyQuery with(IRI iri) {
        return this.with(Rdf.iri(iri));
    }

    public ModifyQuery delete(TriplePattern ... triples) {
        this.deleteTriples = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.deleteTriples, () -> SparqlBuilder.triplesTemplate(new TriplePattern[0]), tt -> tt.and(triples));
        return this;
    }

    public ModifyQuery from(GraphName graphName) {
        this.deleteGraph = Optional.ofNullable(graphName);
        return this;
    }

    public ModifyQuery insert(TriplePattern ... triples) {
        this.insertTriples = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.insertTriples, () -> SparqlBuilder.triplesTemplate(new TriplePattern[0]), tt -> tt.and(triples));
        return this;
    }

    public ModifyQuery into(GraphName graphName) {
        this.insertGraph = Optional.ofNullable(graphName);
        return this;
    }

    public ModifyQuery using(Iri iri) {
        this.using = Optional.ofNullable(iri);
        return this;
    }

    public ModifyQuery using(IRI iri) {
        return this.using(Rdf.iri(iri));
    }

    public ModifyQuery usingNamed(Iri iri) {
        this.usingNamed = true;
        return this.using(iri);
    }

    public ModifyQuery usingNamed(IRI iri) {
        return this.usingNamed(Rdf.iri(iri));
    }

    public ModifyQuery where(GraphPattern ... patterns) {
        this.where.where(patterns);
        return this;
    }

    @Override
    protected String getQueryActionString() {
        StringBuilder modifyQuery = new StringBuilder();
        this.with.ifPresent(withIri -> modifyQuery.append(WITH).append(" ").append(withIri.getQueryString()).append("\n"));
        this.deleteTriples.ifPresent(delTriples -> {
            modifyQuery.append(DELETE).append(" ");
            if (!delTriples.isEmpty()) {
                this.appendNamedTriplesTemplates(modifyQuery, this.deleteGraph, (TriplesTemplate)delTriples);
            }
            modifyQuery.append("\n");
        });
        this.insertTriples.ifPresent(insTriples -> {
            modifyQuery.append(INSERT).append(" ");
            this.appendNamedTriplesTemplates(modifyQuery, this.insertGraph, (TriplesTemplate)insTriples);
            modifyQuery.append("\n");
        });
        this.using.ifPresent(usingIri -> {
            modifyQuery.append(USING).append(" ");
            if (this.usingNamed) {
                modifyQuery.append(NAMED).append(" ");
            }
            modifyQuery.append(usingIri.getQueryString());
            modifyQuery.append("\n");
        });
        modifyQuery.append(this.where.getQueryString());
        return modifyQuery.toString();
    }
}

