/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.FedXLeftJoin;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.FederatedDescribeOperator;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.SingleSourceQuery;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.cache.CacheUtils;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStatistics;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelServiceExecutor;
import org.eclipse.rdf4j.federated.evaluation.iterator.FederatedDescribeIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerLeftJoin;
import org.eclipse.rdf4j.federated.evaluation.union.ControlledWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelGetStatementsTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedAlgebraUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelUnionOperatorTask;
import org.eclipse.rdf4j.federated.evaluation.union.SynchronousWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.WorkerUnionBase;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.optimizer.DefaultFedXCostModel;
import org.eclipse.rdf4j.federated.optimizer.ExclusiveTupleExprOptimizer;
import org.eclipse.rdf4j.federated.optimizer.FilterOptimizer;
import org.eclipse.rdf4j.federated.optimizer.GenericInfoOptimizer;
import org.eclipse.rdf4j.federated.optimizer.LimitOptimizer;
import org.eclipse.rdf4j.federated.optimizer.ServiceOptimizer;
import org.eclipse.rdf4j.federated.optimizer.SourceSelection;
import org.eclipse.rdf4j.federated.optimizer.StatementGroupAndJoinOptimizer;
import org.eclipse.rdf4j.federated.optimizer.UnionOptimizer;
import org.eclipse.rdf4j.federated.structures.FedXDataset;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.RepositoryFederatedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationEvalStrategy
extends StrictEvaluationStrategy {
    private static final Logger log = LoggerFactory.getLogger(FederationEvalStrategy.class);
    protected Executor executor;
    protected SourceSelectionCache cache;
    protected FederationContext federationContext;

    public FederationEvalStrategy(FederationContext federationContext) {
        super(new org.eclipse.rdf4j.query.algebra.evaluation.TripleSource(){

            @Override
            public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
                throw new FedXRuntimeException("Federation Strategy does not support org.openrdf.query.algebra.evaluation.TripleSource#getStatements. If you encounter this exception, please report it.");
            }

            @Override
            public ValueFactory getValueFactory() {
                return SimpleValueFactory.getInstance();
            }
        }, federationContext.getFederatedServiceResolver());
        this.federationContext = federationContext;
        this.executor = federationContext.getManager().getExecutor();
        this.cache = federationContext.getSourceSelectionCache();
    }

    @Override
    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        List<Endpoint> members;
        if (!(evaluationStatistics instanceof FederationEvaluationStatistics)) {
            throw new FedXRuntimeException("Expected FederationEvaluationStatistics, was " + evaluationStatistics.getClass());
        }
        FederationEvaluationStatistics stats = (FederationEvaluationStatistics)evaluationStatistics;
        QueryInfo queryInfo = stats.getQueryInfo();
        Dataset dataset = stats.getDataset();
        FederationContext federationContext = queryInfo.getFederationContext();
        if (dataset instanceof FedXDataset) {
            FedXDataset ds = (FedXDataset)dataset;
            members = federationContext.getEndpointManager().getEndpoints(ds.getEndpoints());
        } else {
            FedX fed = federationContext.getFederation();
            members = fed.getMembers();
        }
        TupleExpr clone = expr.clone();
        TupleExpr query = clone instanceof QueryRoot ? clone : new QueryRoot(clone);
        GenericInfoOptimizer info = new GenericInfoOptimizer(queryInfo);
        info.optimize(query);
        if (members.size() == 1 && queryInfo.getQuery() != null && this.propagateServices(info.getServices()) && queryInfo.getQueryType() != QueryType.UPDATE) {
            return new SingleSourceQuery(expr, members.get(0), queryInfo);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query before Optimization: " + query);
        }
        new ConstantOptimizer(this).optimize(query, dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize(query, dataset, bindings);
        Set<Endpoint> relevantSources = this.performSourceSelection(members, this.cache, queryInfo, info);
        if (relevantSources.size() == 1 && this.propagateServices(info.getServices()) && queryInfo.getQueryType() != QueryType.UPDATE && queryInfo.getQueryType() != QueryType.DESCRIBE) {
            return new SingleSourceQuery(query, relevantSources.iterator().next(), queryInfo);
        }
        if (info.hasService()) {
            new ServiceOptimizer(queryInfo).optimize(query);
        }
        if (info.hasUnion()) {
            new UnionOptimizer(queryInfo).optimize(query);
        }
        this.optimizeExclusiveExpressions(query, queryInfo, info);
        this.optimizeJoinOrder(query, queryInfo, info);
        if (info.hasLimit()) {
            new LimitOptimizer().optimize(query);
        }
        if (info.hasFilter()) {
            new FilterOptimizer().optimize(query);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query after Optimization: " + query);
        }
        return query;
    }

    protected Set<Endpoint> performSourceSelection(List<Endpoint> members, SourceSelectionCache cache, QueryInfo queryInfo, GenericInfoOptimizer info) {
        SourceSelection sourceSelection = new SourceSelection(members, cache, queryInfo);
        sourceSelection.doSourceSelection(info.getStatements());
        return sourceSelection.getRelevantSources();
    }

    protected void optimizeJoinOrder(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new StatementGroupAndJoinOptimizer(queryInfo, DefaultFedXCostModel.INSTANCE).optimize(query);
    }

    protected boolean propagateServices(List<Service> serviceNodes) {
        boolean hasServices;
        boolean bl = hasServices = serviceNodes != null && !serviceNodes.isEmpty();
        return !hasServices;
    }

    protected void optimizeExclusiveExpressions(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new ExclusiveTupleExprOptimizer().optimize(query);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)expr).evaluate(bindings);
        }
        if (expr instanceof NJoin) {
            return this.evaluateNJoin((NJoin)expr, bindings);
        }
        if (expr instanceof NUnion) {
            return this.evaluateNaryUnion((NUnion)expr, bindings);
        }
        if (expr instanceof ExclusiveGroup) {
            return ((ExclusiveGroup)expr).evaluate(bindings);
        }
        if (expr instanceof ExclusiveTupleExpr) {
            return this.evaluateExclusiveTupleExpr((ExclusiveTupleExpr)expr, bindings);
        }
        if (expr instanceof FedXLeftJoin) {
            return this.evaluateLeftJoin((FedXLeftJoin)expr, bindings);
        }
        if (expr instanceof SingleSourceQuery) {
            return this.evaluateSingleSourceQuery((SingleSourceQuery)expr, bindings);
        }
        if (expr instanceof FedXService) {
            return this.evaluateService((FedXService)expr, bindings);
        }
        if (expr instanceof EmptyResult) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        return super.evaluate(expr, bindings);
    }

    @Override
    public QueryEvaluationStep precompile(TupleExpr expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        if (expr instanceof StatementTupleExpr) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        if (expr instanceof NJoin) {
            return this.prepareNJoin((NJoin)expr, context);
        }
        if (expr instanceof NUnion) {
            return this.prepareNaryUnion((NUnion)expr, context);
        }
        if (expr instanceof ExclusiveGroup) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        if (expr instanceof ExclusiveTupleExpr) {
            return this.prepareExclusiveTupleExpr((ExclusiveTupleExpr)expr, context);
        }
        if (expr instanceof FedXLeftJoin) {
            return this.prepareLeftJoin((FedXLeftJoin)expr, context);
        }
        if (expr instanceof SingleSourceQuery) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        if (expr instanceof FedXService) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        if (expr instanceof EmptyResult) {
            return QueryEvaluationStep.minimal(this, expr);
        }
        return super.precompile(expr, context);
    }

    public CloseableIteration<Statement, QueryEvaluationException> getStatements(QueryInfo queryInfo, Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        List<Endpoint> members = this.federationContext.getFederation().getMembers();
        if (subj != null && pred != null && obj != null) {
            if (CacheUtils.checkCacheUpdateCache(this.cache, members, subj, pred, obj, queryInfo, contexts)) {
                return new SingletonIteration<Statement, QueryEvaluationException>(FedXUtil.valueFactory().createStatement(subj, pred, obj));
            }
            return new EmptyIteration<Statement, QueryEvaluationException>();
        }
        List<StatementSource> sources = CacheUtils.checkCacheForStatementSourcesUpdateCache(this.cache, members, subj, pred, obj, queryInfo, contexts);
        if (sources.isEmpty()) {
            return new EmptyIteration<Statement, QueryEvaluationException>();
        }
        if (sources.size() == 1) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(sources.get(0).getEndpointID());
            return e.getTripleSource().getStatements(subj, pred, obj, queryInfo, contexts);
        }
        SynchronousWorkerUnion<Statement> union = new SynchronousWorkerUnion<Statement>(queryInfo);
        for (StatementSource source : sources) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
            ParallelGetStatementsTask task = new ParallelGetStatementsTask(union, e, subj, pred, obj, queryInfo, contexts);
            union.addTask(task);
        }
        this.executor.execute(union);
        return union;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateService(FedXService service, BindingSet bindings) throws QueryEvaluationException {
        ParallelServiceExecutor pe = new ParallelServiceExecutor(service, this, bindings, this.federationContext);
        pe.run();
        return pe;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateSingleSourceQuery(SingleSourceQuery query, BindingSet bindings) throws QueryEvaluationException {
        try {
            Endpoint source = query.getSource();
            return source.getTripleSource().getStatements(query.getQueryString(), bindings, query.getQueryInfo().getQueryType(), query.getQueryInfo());
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateNJoin(NJoin join, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(join).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareNJoin(final NJoin join, QueryEvaluationContext context) throws QueryEvaluationException {
        final QueryEvaluationStep resultProvider = this.precompile(join.getArg(0), context);
        final ControlledWorkerScheduler<BindingSet> joinScheduler = this.federationContext.getManager().getJoinScheduler();
        return new QueryEvaluationStep(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                boolean completed = false;
                CloseableIteration<BindingSet, QueryEvaluationException> result = resultProvider.evaluate(bindings);
                try {
                    int n = join.getNumberOfArguments();
                    for (int i = 1; i < n; ++i) {
                        result = FederationEvalStrategy.this.executeJoin(joinScheduler, result, join.getArg(i), join.getJoinVariables(i), bindings, join.getQueryInfo());
                    }
                    completed = true;
                }
                finally {
                    if (!completed) {
                        result.close();
                    }
                }
                return result;
            }
        };
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateLeftJoin(FedXLeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(leftJoin).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareLeftJoin(final FedXLeftJoin leftJoin, final QueryEvaluationContext context) throws QueryEvaluationException {
        if (TupleExprs.containsSubquery(leftJoin.getRightArg())) {
            return new QueryEvaluationStep(){
                final QueryEvaluationStep leftES;
                final QueryEvaluationStep rightES;
                {
                    this.leftES = FederationEvalStrategy.this.precompile(leftJoin.getLeftArg(), context);
                    this.rightES = FederationEvalStrategy.this.precompile(leftJoin.getRightArg(), context);
                }

                @Override
                public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                    String[] hashJoinAttributeNames = HashJoinIteration.hashJoinAttributeNames(leftJoin);
                    return new HashJoinIteration(this.leftES, this.rightES, bindings, true, hashJoinAttributeNames, context);
                }
            };
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit(optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit(optionalVarCollector);
        }
        final Set<String> problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        final QueryEvaluationStep leftPrepared = this.precompile(leftJoin.getLeftArg(), context);
        final ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getLeftJoinScheduler();
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                HashSet<String> problemVarsClone = new HashSet<String>(problemVars);
                problemVarsClone.retainAll(bindings.getBindingNames());
                if (problemVarsClone.isEmpty()) {
                    CloseableIteration<BindingSet, QueryEvaluationException> leftIter = leftPrepared.evaluate(bindings);
                    ControlledWorkerLeftJoin join = new ControlledWorkerLeftJoin(scheduler, FederationEvalStrategy.this, leftIter, leftJoin, bindings, leftJoin.getQueryInfo());
                    FederationEvalStrategy.this.executor.execute(join);
                    return join;
                }
                return new BadlyDesignedLeftJoinIterator(FederationEvalStrategy.this, leftJoin, bindings, problemVarsClone, context);
            }
        };
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateNaryUnion(NUnion union, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(union).evaluate(bindings);
    }

    public QueryEvaluationStep prepareNaryUnion(NUnion union, QueryEvaluationContext context) throws QueryEvaluationException {
        ControlledWorkerScheduler<BindingSet> unionScheduler = this.federationContext.getManager().getUnionScheduler();
        final ControlledWorkerUnion<BindingSet> unionRunnable = new ControlledWorkerUnion<BindingSet>(unionScheduler, union.getQueryInfo());
        final int numberOfArguments = union.getNumberOfArguments();
        final QueryEvaluationStep[] args = new QueryEvaluationStep[numberOfArguments];
        for (int i = 0; i < numberOfArguments; ++i) {
            args[i] = this.precompile(union.getArg(i), context);
        }
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                for (int i = 0; i < numberOfArguments; ++i) {
                    unionRunnable.addTask(new ParallelUnionOperatorTask(unionRunnable, args[i], bindings));
                }
                FederationEvalStrategy.this.executor.execute(unionRunnable);
                return unionRunnable;
            }
        };
    }

    protected abstract CloseableIteration<BindingSet, QueryEvaluationException> executeJoin(ControlledWorkerScheduler<BindingSet> var1, CloseableIteration<BindingSet, QueryEvaluationException> var2, TupleExpr var3, Set<String> var4, BindingSet var5, QueryInfo var6) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateExclusiveGroup(ExclusiveGroup var1, BindingSet var2) throws RepositoryException, MalformedQueryException, QueryEvaluationException;

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateExclusiveTupleExpr(ExclusiveTupleExpr expr, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.precompile(expr).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareExclusiveTupleExpr(final ExclusiveTupleExpr expr, QueryEvaluationContext context) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return new QueryEvaluationStep(){

                @Override
                public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                    return ((StatementTupleExpr)((Object)expr)).evaluate(bindings);
                }
            };
        }
        if (!(expr instanceof ExclusiveTupleExprRenderer)) {
            return super.precompile(expr);
        }
        Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(expr.getOwner().getEndpointID());
        final TripleSource t = ownedEndpoint.getTripleSource();
        return new QueryEvaluationStep(){

            @Override
            public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) {
                AtomicBoolean isEvaluated = new AtomicBoolean(false);
                FilterValueExpr filterValueExpr = null;
                try {
                    String preparedQuery = QueryStringUtil.selectQueryString((ExclusiveTupleExprRenderer)expr, bindings, filterValueExpr, isEvaluated, expr.getQueryInfo().getDataset());
                    return t.getStatements(preparedQuery, bindings, isEvaluated.get() ? null : filterValueExpr, expr.getQueryInfo());
                }
                catch (IllegalQueryException e) {
                    if (t.hasStatements(expr, bindings)) {
                        return new SingleBindingSetIteration(bindings);
                    }
                    return new EmptyIteration<BindingSet, QueryEvaluationException>();
                }
            }
        };
    }

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateBoundJoinStatementPattern(StatementTupleExpr var1, List<BindingSet> var2) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluateGroupedCheck(CheckStatementPattern var1, List<BindingSet> var2) throws QueryEvaluationException;

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateService(FedXService service, List<BindingSet> bindings) throws QueryEvaluationException {
        Var serviceRef = service.getService().getServiceRef();
        if (!serviceRef.hasValue()) {
            return new ServiceJoinIterator(new CollectionIteration<BindingSet, QueryEvaluationException>(bindings), service.getService(), EmptyBindingSet.getInstance(), this);
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = this.getService(serviceUri);
        if (fs instanceof RepositoryFederatedService) {
            ((RepositoryFederatedService)fs).setBoundJoinBlockSize(0);
        }
        return fs.evaluate(service.getService(), new CollectionIteration<BindingSet, QueryEvaluationException>(bindings), service.getService().getBaseURI());
    }

    @Override
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof FilterExpr) {
            return this.evaluate((FilterExpr)expr, bindings);
        }
        if (expr instanceof ConjunctiveFilterExpr) {
            return this.evaluate((ConjunctiveFilterExpr)expr, bindings);
        }
        return super.evaluate(expr, bindings);
    }

    @Override
    public QueryValueEvaluationStep precompile(ValueExpr expr, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof FilterExpr) {
            return this.prepare((FilterExpr)expr, context);
        }
        if (expr instanceof ConjunctiveFilterExpr) {
            return this.prepare((ConjunctiveFilterExpr)expr, context);
        }
        return super.precompile(expr, context);
    }

    public Value evaluate(FilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getExpression(), bindings);
        return BooleanLiteral.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(v));
    }

    protected QueryValueEvaluationStep prepare(FilterExpr node, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        final QueryValueEvaluationStep expr = this.precompile(node.getExpression(), context);
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
                Value v = expr.evaluate(bindings);
                return BooleanLiteral.valueOf(QueryEvaluationUtil.getEffectiveBooleanValue(v));
            }
        };
    }

    public Value evaluate(ConjunctiveFilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return this.prepare(node, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(ConjunctiveFilterExpr node, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        final List collect = node.getExpressions().stream().map(e -> this.precompile((ValueExpr)e, context)).collect(Collectors.toList());
        return new QueryValueEvaluationStep(){

            @Override
            public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
                ValueExprEvaluationException error = null;
                try {
                    for (QueryValueEvaluationStep ves : collect) {
                        Value v = ves.evaluate(bindings);
                        if (QueryEvaluationUtil.getEffectiveBooleanValue(v)) continue;
                        return BooleanLiteral.FALSE;
                    }
                }
                catch (ValueExprEvaluationException e) {
                    error = e;
                }
                if (error != null) {
                    throw error;
                }
                return BooleanLiteral.TRUE;
            }
        };
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(DescribeOperator operator, BindingSet bindings) throws QueryEvaluationException {
        if (!(operator instanceof FederatedDescribeOperator)) {
            throw new FedXRuntimeException("Expected a FedXDescribeOperator Node. Found " + operator.getClass() + " instead.");
        }
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.evaluate(operator.getArg(), bindings);
        return new FederatedDescribeIteration(iter, this, operator.getBindingNames(), bindings, ((FederatedDescribeOperator)operator).getQueryInfo());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(Object preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        if (preparedQuery instanceof String) {
            return this.evaluateAtStatementSources((String)preparedQuery, statementSources, queryInfo);
        }
        if (preparedQuery instanceof TupleExpr) {
            return this.evaluateAtStatementSources((TupleExpr)preparedQuery, statementSources, queryInfo);
        }
        throw new RuntimeException("Unsupported type for prepared query: " + preparedQuery.getClass().getCanonicalName());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(String preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            CloseableIteration<Object, QueryEvaluationException> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), (FilterValueExpr)null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryEvaluationException(e);
        }
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateAtStatementSources(TupleExpr preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            CloseableIteration<Object, QueryEvaluationException> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedAlgebraUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryEvaluationException(e);
        }
    }
}

