/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;

class MemEvaluationStatistics
extends EvaluationStatistics {
    private final MemValueFactory valueFactory;
    private final MemStatementList memStatementList;

    MemEvaluationStatistics(MemValueFactory valueFactory, MemStatementList memStatementList) {
        this.valueFactory = valueFactory;
        this.memStatementList = memStatementList;
    }

    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new MemCardinalityCalculator();
    }

    protected class MemCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected MemCardinalityCalculator() {
        }

        public double getCardinality(StatementPattern sp) {
            Value pred;
            Value subj = this.getConstantValue(sp.getSubjectVar());
            if (subj == null || !subj.isResource()) {
                subj = null;
            }
            if ((pred = this.getConstantValue(sp.getPredicateVar())) == null || !pred.isIRI()) {
                pred = null;
            }
            Value obj = this.getConstantValue(sp.getObjectVar());
            Value context = this.getConstantValue(sp.getContextVar());
            if (context == null || !context.isResource()) {
                context = null;
            }
            if (subj == null && pred == null && obj == null && context == null) {
                return MemEvaluationStatistics.this.memStatementList.size();
            }
            return this.minStatementCount(subj, pred, obj, context);
        }

        private int minStatementCount(Value subj, Value pred, Value obj, Value context) {
            int minListSizes = Integer.MAX_VALUE;
            if (subj != null) {
                MemResource memSubj = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)subj);
                if (memSubj != null) {
                    minListSizes = memSubj.getSubjectStatementCount();
                    if (minListSizes == 0) {
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            if (pred != null) {
                MemIRI memPred = MemEvaluationStatistics.this.valueFactory.getMemURI((IRI)pred);
                if (memPred != null) {
                    if ((minListSizes = Math.min(minListSizes, memPred.getPredicateStatementCount())) == 0) {
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            if (obj != null) {
                MemValue memObj = MemEvaluationStatistics.this.valueFactory.getMemValue(obj);
                if (memObj != null) {
                    if ((minListSizes = Math.min(minListSizes, memObj.getObjectStatementCount())) == 0) {
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
            if (context != null) {
                MemResource memContext = MemEvaluationStatistics.this.valueFactory.getMemResource((Resource)context);
                if (memContext != null) {
                    minListSizes = Math.min(minListSizes, memContext.getContextStatementCount());
                } else {
                    return 0;
                }
            }
            assert (minListSizes != Integer.MAX_VALUE) : "minListSizes should have been updated before this point";
            return minListSizes;
        }

        protected Value getConstantValue(Var var) {
            if (var != null) {
                return var.getValue();
            }
            return null;
        }
    }
}

