/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public class TripleRef
extends AbstractQueryModelNode
implements TupleExpr {
    private Var exprVar;
    private Var subjectVar;
    private Var predicateVar;
    private Var objectVar;

    public Var getSubjectVar() {
        return this.subjectVar;
    }

    public void setSubjectVar(Var subject) {
        assert (subject != null) : "subject must not be null";
        subject.setParentNode(this);
        this.subjectVar = subject;
    }

    public Var getPredicateVar() {
        return this.predicateVar;
    }

    public void setPredicateVar(Var predicate) {
        assert (predicate != null) : "predicate must not be null";
        predicate.setParentNode(this);
        this.predicateVar = predicate;
    }

    public Var getObjectVar() {
        return this.objectVar;
    }

    public void setObjectVar(Var object) {
        assert (object != null) : "object must not be null";
        object.setParentNode(this);
        this.objectVar = object;
    }

    public Var getExprVar() {
        return this.exprVar;
    }

    public void setExprVar(Var context) {
        if (context != null) {
            context.setParentNode(this);
        }
        this.exprVar = context;
    }

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>(8);
        if (this.subjectVar != null) {
            bindingNames.add(this.subjectVar.getName());
        }
        if (this.predicateVar != null) {
            bindingNames.add(this.predicateVar.getName());
        }
        if (this.objectVar != null) {
            bindingNames.add(this.objectVar.getName());
        }
        if (this.exprVar != null) {
            bindingNames.add(this.exprVar.getName());
        }
        return bindingNames;
    }

    public List<Var> getVarList() {
        return this.getVars(new ArrayList(4));
    }

    public <L extends Collection<Var>> L getVars(L varCollection) {
        if (this.subjectVar != null) {
            varCollection.add((Var)this.subjectVar);
        }
        if (this.predicateVar != null) {
            varCollection.add((Var)this.predicateVar);
        }
        if (this.objectVar != null) {
            varCollection.add((Var)this.objectVar);
        }
        if (this.exprVar != null) {
            varCollection.add((Var)this.exprVar);
        }
        return varCollection;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.subjectVar != null) {
            this.subjectVar.visit(visitor);
        }
        if (this.predicateVar != null) {
            this.predicateVar.visit(visitor);
        }
        if (this.objectVar != null) {
            this.objectVar.visit(visitor);
        }
        if (this.exprVar != null) {
            this.exprVar.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.subjectVar == current) {
            this.setSubjectVar((Var)replacement);
        } else if (this.predicateVar == current) {
            this.setPredicateVar((Var)replacement);
        } else if (this.objectVar == current) {
            this.setObjectVar((Var)replacement);
        } else if (this.exprVar == current) {
            this.setExprVar((Var)replacement);
        }
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.getSignature());
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TripleRef) {
            TripleRef o = (TripleRef)other;
            return this.subjectVar.equals(o.getSubjectVar()) && this.predicateVar.equals(o.getPredicateVar()) && this.objectVar.equals(o.getObjectVar());
        }
        return false;
    }

    public int hashCode() {
        int result = this.subjectVar.hashCode();
        result ^= this.predicateVar.hashCode();
        result ^= this.objectVar.hashCode();
        if (this.exprVar != null) {
            result ^= this.exprVar.hashCode();
        }
        return result;
    }

    @Override
    public TripleRef clone() {
        TripleRef clone = (TripleRef)super.clone();
        clone.setSubjectVar(this.getSubjectVar().clone());
        clone.setPredicateVar(this.getPredicateVar().clone());
        clone.setObjectVar(this.getObjectVar().clone());
        if (this.getExprVar() != null) {
            clone.setExprVar(this.getExprVar().clone());
        }
        return clone;
    }
}

