/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class Var
extends AbstractQueryModelNode
implements ValueExpr {
    private String name;
    private Value value;
    private boolean anonymous = false;
    private boolean constant = false;
    private QueryModelNode parent;
    private int cachedHashCode = 0;

    @Deprecated(forRemoval=true, since="4.1.0")
    public Var() {
    }

    public Var(String name, Value value, boolean anonymous, boolean constant) {
        this.name = name;
        this.value = value;
        this.anonymous = anonymous;
        this.constant = constant;
    }

    public Var(String name) {
        this(name, null, false, false);
    }

    public Var(String name, boolean anonymous) {
        this(name, null, anonymous, false);
    }

    public Var(String name, Value value) {
        this(name, value, false, false);
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public void setAnonymous(boolean anonymous) {
        this.cachedHashCode = 0;
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public void setName(String name) {
        this.cachedHashCode = 0;
        this.name = name;
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public void setValue(Value value) {
        this.cachedHashCode = 0;
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public QueryModelNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(QueryModelNode parent) {
        this.parent = parent;
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
    }

    @Override
    public void replaceWith(QueryModelNode replacement) {
        if (this.parent == null) {
            throw new IllegalStateException("Node has no parent");
        }
        this.parent.replaceChildNode(this, replacement);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append(" (name=").append(this.name);
        if (this.value != null) {
            sb.append(", value=").append(this.value);
        }
        if (this.anonymous) {
            sb.append(", anonymous");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Var var = (Var)o;
        if (this.cachedHashCode != 0 && var.cachedHashCode != 0 && this.cachedHashCode != var.cachedHashCode) {
            return false;
        }
        return !(this.anonymous != var.anonymous || this.name == null && var.name != null || this.value == null && var.value != null || !Objects.equals(this.name, var.name) || !Objects.equals(this.value, var.value));
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            this.cachedHashCode = result = 31 * result + Boolean.hashCode(this.anonymous);
        }
        return this.cachedHashCode;
    }

    @Override
    public Var clone() {
        return new Var(this.name, this.value, this.anonymous, this.constant);
    }

    public boolean isConstant() {
        return this.constant;
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    public void setConstant(boolean constant) {
        this.constant = constant;
    }
}

