/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.CrossProductIteration;

public class ZeroLengthPathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private static final Literal OBJECT = SimpleValueFactory.getInstance().createLiteral("object");
    private static final Literal SUBJECT = SimpleValueFactory.getInstance().createLiteral("subject");
    public static final String ANON_SUBJECT_VAR = "zero-length-internal-start";
    public static final String ANON_PREDICATE_VAR = "zero-length-internal-pred";
    public static final String ANON_OBJECT_VAR = "zero-length-internal-end";
    public static final String ANON_SEQUENCE_VAR = "zero-length-internal-seq";
    private QueryBindingSet result;
    private final Value subj;
    private final Value obj;
    private final BindingSet bindings;
    private CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private Set<Value> reportedValues;
    private final Var contextVar;
    private final EvaluationStrategy evaluationStrategy;
    private final QueryEvaluationStep precompile;
    private final QueryEvaluationContext context;
    private final BiConsumer<Value, MutableBindingSet> setSubject;
    private final BiConsumer<Value, MutableBindingSet> setObject;
    private final BiConsumer<Value, MutableBindingSet> setContext;

    public ZeroLengthPathIteration(EvaluationStrategy evaluationStrategyImpl, Var subjectVar, Var objVar, Value subj, Value obj, Var contextVar, BindingSet bindings, QueryEvaluationContext context) {
        this.evaluationStrategy = evaluationStrategyImpl;
        this.context = context;
        this.result = new QueryBindingSet(bindings);
        this.contextVar = contextVar;
        this.subj = subj;
        this.obj = obj;
        this.bindings = bindings;
        Var startVar = this.createAnonVar(ANON_SUBJECT_VAR);
        Var predicate = this.createAnonVar(ANON_PREDICATE_VAR);
        Var endVar = this.createAnonVar(ANON_OBJECT_VAR);
        StatementPattern subjects = contextVar != null ? new StatementPattern(StatementPattern.Scope.NAMED_CONTEXTS, startVar, predicate, endVar, contextVar) : new StatementPattern(startVar, predicate, endVar);
        this.precompile = this.evaluationStrategy.precompile(subjects, context);
        this.setSubject = context.addBinding(subjectVar.getName());
        this.setObject = context.addBinding(objVar.getName());
        this.setContext = contextVar != null ? context.addBinding(contextVar.getName()) : null;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.subj == null && this.obj == null) {
            if (this.reportedValues == null) {
                this.reportedValues = this.evaluationStrategy.makeSet();
            }
            if (this.iter == null) {
                QueryBindingSet bs1 = new QueryBindingSet(1);
                bs1.addBinding(ANON_SEQUENCE_VAR, SUBJECT);
                QueryBindingSet bs2 = new QueryBindingSet(1);
                bs2.addBinding(ANON_SEQUENCE_VAR, OBJECT);
                List<BindingSet> seqList = Arrays.asList(bs1, bs2);
                this.iter = new CrossProductIteration(this.createIteration(), seqList);
            }
            while (this.iter.hasNext()) {
                Value context;
                BindingSet bs;
                boolean isSubjOrObj = (bs = (BindingSet)this.iter.next()).getValue(ANON_SEQUENCE_VAR).stringValue().equals("subject");
                String endpointVarName = isSubjOrObj ? ANON_SUBJECT_VAR : ANON_OBJECT_VAR;
                Value v = bs.getValue(endpointVarName);
                if (!this.reportedValues.add(v)) continue;
                MutableBindingSet next = this.context.createBindingSet(this.bindings);
                this.setSubject.accept(v, next);
                this.setObject.accept(v, next);
                if (this.setContext != null && (context = bs.getValue(this.contextVar.getName())) != null) {
                    this.setContext.accept(context, next);
                }
                return next;
            }
            this.iter.close();
            this.reportedValues = null;
            return null;
        }
        if (this.result != null) {
            if (this.obj == null && this.subj != null) {
                this.setObject.accept(this.subj, this.result);
            } else if (this.subj == null && this.obj != null) {
                this.setSubject.accept(this.obj, this.result);
            } else if (this.subj == null || !this.subj.equals(this.obj)) {
                this.result = null;
            }
        }
        QueryBindingSet next = this.result;
        this.result = null;
        return next;
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> iter = this.precompile.evaluate(this.bindings);
        return iter;
    }

    public Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }
}

