/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.java.client;

import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JDK9ClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(JDK9ClientALPNProcessor.class);

    public void init() {
        if (JavaVersion.VERSION.getPlatform() < 9) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        Module module = sslEngine.getClass().getModule();
        return module != null && "java.base".equals(module.getName());
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        ALPNClientConnection alpn = (ALPNClientConnection)connection;
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        List protocols = alpn.getProtocols();
        sslParameters.setApplicationProtocols(protocols.toArray(new String[protocols.size()]));
        sslEngine.setSSLParameters(sslParameters);
        ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNListener(alpn));
    }

    private final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getSSLEngine().getApplicationProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected protocol {}", new Object[]{protocol});
            }
            this.alpnConnection.selected(protocol);
        }
    }
}

