/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.sail.nativerdf.RecordCache;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

abstract class AbstractRecordCache
implements RecordCache {
    private long maxRecords;
    private final AtomicLong recordCount;

    public AbstractRecordCache() {
        this(Long.MAX_VALUE);
    }

    public AbstractRecordCache(long maxRecords) {
        this.maxRecords = maxRecords;
        this.recordCount = new AtomicLong();
    }

    @Override
    public final void setMaxRecords(long maxRecords) {
        this.maxRecords = maxRecords;
    }

    @Override
    public final long getRecordCount() {
        if (this.isValid()) {
            return this.recordCount.get();
        }
        throw new IllegalStateException();
    }

    @Override
    public final void storeRecord(byte[] data) throws IOException {
        long spareSlots = this.maxRecords - this.recordCount.get();
        if (spareSlots > 0L) {
            this.storeRecordInternal(data);
            this.recordCount.incrementAndGet();
        } else if (spareSlots == 0L) {
            this.recordCount.incrementAndGet();
        }
    }

    @Override
    public final void storeRecords(RecordCache otherCache) throws IOException {
        if (this.recordCount.get() <= this.maxRecords) {
            try (RecordIterator recIter = otherCache.getRecords();){
                byte[] record;
                while ((record = recIter.next()) != null && this.recordCount.incrementAndGet() <= this.maxRecords) {
                    this.storeRecordInternal(record);
                }
            }
        }
    }

    protected abstract void storeRecordInternal(byte[] var1) throws IOException;

    @Override
    public final void clear() throws IOException {
        this.clearInternal();
        this.recordCount.set(0L);
    }

    protected abstract void clearInternal() throws IOException;

    @Override
    public final RecordIterator getRecords() throws IOException {
        if (this.isValid()) {
            return this.getRecordsInternal();
        }
        throw new IllegalStateException();
    }

    protected abstract RecordIterator getRecordsInternal() throws IOException;

    @Override
    public final boolean isValid() {
        return this.recordCount.get() <= this.maxRecords;
    }
}

