/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.config;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;

public class ProxyRepositoryConfig
extends AbstractRepositoryImplConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private String proxiedID;

    public ProxyRepositoryConfig() {
        super("openrdf:ProxyRepository");
    }

    public ProxyRepositoryConfig(String proxiedID) {
        this();
        this.setProxiedRepositoryID(proxiedID);
    }

    public final void setProxiedRepositoryID(String value) {
        this.proxiedID = value;
    }

    public String getProxiedRepositoryID() {
        return this.proxiedID;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (null == this.proxiedID) {
            throw new RepositoryConfigException("No id specified for proxied repository");
        }
    }

    public Resource export(Model model) {
        Resource implNode = super.export(model);
        if (null != this.proxiedID) {
            if (USE_CONFIG) {
                model.add(implNode, CONFIG.Proxy.proxiedID, (Value)Values.literal((String)this.proxiedID), new Resource[0]);
            } else {
                model.add(implNode, ProxyRepositorySchema.PROXIED_ID, (Value)Values.literal((String)this.proxiedID), new Resource[0]);
            }
        }
        return implNode;
    }

    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Configurations.getLiteralValue((Model)model, (Resource)implNode, (IRI)CONFIG.Proxy.proxiedID, (IRI)ProxyRepositorySchema.PROXIED_ID).ifPresent(lit -> this.setProxiedRepositoryID(lit.getLabel()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

