/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> filteredIter;
    private E nextElement;

    protected FilterIterator(Iterator<? extends E> iter) {
        this.filteredIter = iter;
    }

    @Override
    public boolean hasNext() {
        this.findNextElement();
        return this.nextElement != null;
    }

    @Override
    public E next() {
        this.findNextElement();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNextElement() {
        while (this.nextElement == null && this.filteredIter.hasNext()) {
            E candidate = this.filteredIter.next();
            if (!this.accept(candidate)) continue;
            this.nextElement = candidate;
        }
    }

    @Override
    public void remove() {
        this.filteredIter.remove();
    }

    protected abstract boolean accept(E var1);
}

