/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;

public final class NioFile
implements Closeable {
    public static final EnumSet<StandardOpenOption> R = EnumSet.of(StandardOpenOption.READ);
    public static final EnumSet<StandardOpenOption> RW = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    public static final EnumSet<StandardOpenOption> RWS = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC);
    public static final EnumSet<StandardOpenOption> RWD = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC);
    private final File file;
    private final Set<StandardOpenOption> openOptions;
    private volatile FileChannel fc;
    private volatile boolean explictlyClosed;

    public NioFile(File file) throws IOException {
        this(file, "rw");
    }

    public NioFile(File file, String mode) throws IOException {
        this(file, NioFile.toOpenOptions(mode));
    }

    public NioFile(File file, Set<StandardOpenOption> openOptions) throws IOException {
        this.openOptions = openOptions;
        this.explictlyClosed = false;
        this.file = file;
        this.open();
    }

    public NioFile(Path path, Set<StandardOpenOption> openOptions) throws IOException {
        this(path.toFile(), openOptions);
    }

    private static Set<StandardOpenOption> toOpenOptions(String mode) {
        switch (mode) {
            case "r": {
                return R;
            }
            case "rw": {
                return RW;
            }
            case "rws": {
                return RWS;
            }
            case "rwd": {
                return RWD;
            }
        }
        throw new IllegalArgumentException();
    }

    private void open() throws IOException {
        this.fc = FileChannel.open(this.file.toPath(), this.openOptions, new FileAttribute[0]);
    }

    private synchronized void reopen(ClosedChannelException e) throws IOException {
        if (this.explictlyClosed) {
            throw e;
        }
        if (this.fc.isOpen()) {
            return;
        }
        this.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this.explictlyClosed = true;
        this.fc.close();
    }

    public boolean isClosed() {
        return this.explictlyClosed;
    }

    public File getFile() {
        return this.file;
    }

    public boolean delete() throws IOException {
        this.close();
        return this.file.delete();
    }

    public void force(boolean metaData) throws IOException {
        while (true) {
            try {
                this.fc.force(metaData);
                return;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public void truncate(long size) throws IOException {
        while (true) {
            try {
                this.fc.truncate(size);
                return;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public long size() throws IOException {
        while (true) {
            try {
                return this.fc.size();
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        while (true) {
            try {
                return this.fc.transferTo(position, count, target);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public int write(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.write(buf, offset);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public int read(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.read(buf, offset);
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                this.reopen(e);
                continue;
            }
            break;
        }
    }

    public void writeBytes(byte[] value, long offset) throws IOException {
        this.write(ByteBuffer.wrap(value), offset);
    }

    public byte[] readBytes(long offset, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(length);
        this.read(buf, offset);
        return buf.array();
    }

    public void writeByte(byte value, long offset) throws IOException {
        this.writeBytes(new byte[]{value}, offset);
    }

    public byte readByte(long offset) throws IOException {
        return this.readBytes(offset, 1)[0];
    }

    public void writeLong(long value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, value);
        this.write(buf, offset);
    }

    public long readLong(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        this.read(buf, offset);
        return buf.getLong(0);
    }

    public void writeInt(int value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(0, value);
        this.write(buf, offset);
    }

    public int readInt(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.read(buf, offset);
        return buf.getInt(0);
    }
}

