/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.paths;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.shacl.ast.Exportable;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.paths.AlternativePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.InversePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.OneOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SequencePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrMorePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.ZeroOrOnePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public abstract class Path
implements Identifiable,
Exportable,
Targetable {
    Resource id;

    public Path(Resource id) {
        this.id = id;
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    public static Path buildPath(ShapeSource shapeSource, Resource id) {
        if (id == null) {
            return null;
        }
        if (id.isBNode()) {
            List collect = shapeSource.getAllStatements(id).collect(Collectors.toList());
            for (Statement statement : collect) {
                IRI pathType = statement.getPredicate();
                switch (pathType.toString()) {
                    case "http://www.w3.org/ns/shacl#inversePath": {
                        return new InversePath(id, (Resource)statement.getObject(), shapeSource);
                    }
                    case "http://www.w3.org/ns/shacl#alternativePath": {
                        return new AlternativePath(id, (Resource)statement.getObject(), shapeSource);
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrMorePath": {
                        return new ZeroOrMorePath(id, (Resource)statement.getObject(), shapeSource);
                    }
                    case "http://www.w3.org/ns/shacl#oneOrMorePath": {
                        return new OneOrMorePath(id, (Resource)statement.getObject(), shapeSource);
                    }
                    case "http://www.w3.org/ns/shacl#zeroOrOnePath": {
                        return new ZeroOrOnePath(id, (Resource)statement.getObject(), shapeSource);
                    }
                    case "http://www.w3.org/1999/02/22-rdf-syntax-ns#first": {
                        return new SequencePath(id, shapeSource);
                    }
                }
            }
            throw new ShaclUnsupportedException();
        }
        return new SimplePath((IRI)id);
    }

    public abstract PlanNode getAllAdded(ConnectionsGroup var1, Resource[] var2, PlanNodeWrapper var3);

    public abstract PlanNode getAnyAdded(ConnectionsGroup var1, Resource[] var2, PlanNodeWrapper var3);

    public String getVariablePrefix(StatementMatcher.Variable subject, StatementMatcher.Variable object) {
        String className = this.getClass().getSimpleName();
        return subject.getName() + "_" + (object != null ? object.getName() : "null") + "_" + className + "_";
    }

    public abstract boolean isSupported();

    public abstract String toSparqlPathString();

    @Override
    public final Set<Namespace> getNamespaces() {
        return Set.of();
    }
}

