/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;

@FunctionalInterface
public interface QueryEvaluationStep {
    public static final EmptyIteration<BindingSet> EMPTY_ITERATION = new EmptyIteration();
    public static final QueryEvaluationStep EMPTY = bindings -> EMPTY_ITERATION;

    public CloseableIteration<BindingSet> evaluate(BindingSet var1);

    public static QueryEvaluationStep minimal(EvaluationStrategy strategy, TupleExpr expr) {
        return bs -> strategy.evaluate(expr, bs);
    }

    public static QueryEvaluationStep empty() {
        return bs -> new EmptyIteration();
    }

    public static QueryEvaluationStep wrap(QueryEvaluationStep qes, Function<CloseableIteration<BindingSet>, CloseableIteration<BindingSet>> wrap) {
        return bs -> (CloseableIteration)wrap.apply(qes.evaluate(bs));
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static class DelayedEvaluationIteration
    extends DelayedIteration<BindingSet> {
        private final QueryEvaluationStep arg;
        private final BindingSet bs;

        public DelayedEvaluationIteration(QueryEvaluationStep arg, BindingSet bs) {
            this.arg = arg;
            this.bs = bs;
        }

        @Override
        protected CloseableIteration<? extends BindingSet> createIteration() throws QueryEvaluationException {
            return this.arg.evaluate(this.bs);
        }
    }
}

