/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleParserSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TurtleParser
extends AbstractRDFParser {
    private PushbackReader reader;
    protected Resource subject;
    protected IRI predicate;
    protected Value object;
    private int lineNumber = 1;
    private final StringBuilder parsingBuilder = new StringBuilder();
    private Statement previousStatement;

    public TurtleParser() {
    }

    public TurtleParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(TurtleParserSettings.CASE_INSENSITIVE_DIRECTIVES);
        result.add(TurtleParserSettings.ACCEPT_TURTLESTAR);
        return result;
    }

    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream must not be 'null'");
        }
        try {
            this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), StandardCharsets.UTF_8), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.clear();
        try {
            if (reader == null) {
                throw new IllegalArgumentException("Reader must not be 'null'");
            }
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            this.lineNumber = 1;
            this.reader = new PushbackReader(reader, 10);
            if (baseURI != null) {
                this.setBaseURI(baseURI);
            }
            this.reportLocation();
            int c = this.skipWSC();
            while (c != -1) {
                this.parseStatement();
                c = this.skipWSC();
            }
        }
        finally {
            this.clear();
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    protected void parseStatement() throws IOException, RDFParseException, RDFHandlerException {
        StringBuilder sb = new StringBuilder(8);
        do {
            int codePoint;
            if ((codePoint = this.readCodePoint()) == -1 || TurtleUtil.isWhitespace(codePoint)) {
                this.unread(codePoint);
                break;
            }
            TurtleParser.appendCodepoint(sb, codePoint);
        } while (sb.length() < 8);
        String directive = sb.toString();
        if (directive.startsWith("@") || directive.equalsIgnoreCase("prefix") || directive.equalsIgnoreCase("base")) {
            this.parseDirective(directive);
            this.skipWSC();
            if (directive.startsWith("@")) {
                this.verifyCharacterOrFail(this.readCodePoint(), ".");
            }
        } else {
            this.unread(directive);
            this.parseTriples();
            this.skipWSC();
            this.verifyCharacterOrFail(this.readCodePoint(), ".");
        }
    }

    protected void parseDirective(String directive) throws IOException, RDFParseException, RDFHandlerException {
        if (directive.length() >= 7 && directive.substring(0, 7).equals("@prefix")) {
            if (directive.length() > 7) {
                this.unread(directive.substring(7));
            }
            this.parsePrefixID();
        } else if (directive.length() >= 5 && directive.substring(0, 5).equals("@base")) {
            if (directive.length() > 5) {
                this.unread(directive.substring(5));
            }
            this.parseBase();
        } else if (directive.length() >= 6 && directive.substring(0, 6).equalsIgnoreCase("prefix")) {
            if (directive.length() > 6) {
                this.unread(directive.substring(6));
            }
            this.parsePrefixID();
        } else if (directive.length() >= 4 && directive.substring(0, 4).equalsIgnoreCase("base")) {
            if (directive.length() > 4) {
                this.unread(directive.substring(4));
            }
            this.parseBase();
        } else if (directive.length() >= 7 && directive.substring(0, 7).equalsIgnoreCase("@prefix")) {
            if (!((Boolean)this.getParserConfig().get(TurtleParserSettings.CASE_INSENSITIVE_DIRECTIVES)).booleanValue()) {
                this.reportFatalError("Cannot strictly support case-insensitive @prefix directive in compliance mode.");
            }
            if (directive.length() > 7) {
                this.unread(directive.substring(7));
            }
            this.parsePrefixID();
        } else if (directive.length() >= 5 && directive.substring(0, 5).equalsIgnoreCase("@base")) {
            if (!((Boolean)this.getParserConfig().get(TurtleParserSettings.CASE_INSENSITIVE_DIRECTIVES)).booleanValue()) {
                this.reportFatalError("Cannot strictly support case-insensitive @base directive in compliance mode.");
            }
            if (directive.length() > 5) {
                this.unread(directive.substring(5));
            }
            this.parseBase();
        } else if (directive.length() == 0) {
            this.reportFatalError("Directive name is missing, expected @prefix or @base");
        } else {
            this.reportFatalError("Unknown directive \"" + directive + "\"");
        }
    }

    protected void parsePrefixID() throws IOException, RDFParseException, RDFHandlerException {
        this.skipWSC();
        StringBuilder prefixID = new StringBuilder(8);
        while (true) {
            int c;
            if ((c = this.readCodePoint()) == 58) {
                this.unread(c);
                break;
            }
            if (TurtleUtil.isWhitespace(c)) break;
            if (c == -1) {
                this.throwEOFException();
            }
            TurtleParser.appendCodepoint(prefixID, c);
        }
        this.skipWSC();
        this.verifyCharacterOrFail(this.readCodePoint(), ":");
        this.skipWSC();
        String namespaceStr = this.parseURI().toString();
        String prefixStr = prefixID.toString();
        this.setNamespace(prefixStr, namespaceStr);
        if (this.rdfHandler != null) {
            this.rdfHandler.handleNamespace(prefixStr, namespaceStr);
        }
    }

    protected void parseBase() throws IOException, RDFParseException, RDFHandlerException {
        this.skipWSC();
        IRI baseURI = this.parseURI();
        this.setBaseURI(baseURI.toString());
    }

    protected void parseTriples() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peekCodePoint();
        if (c == 91) {
            c = this.readCodePoint();
            this.skipWSC();
            c = this.peekCodePoint();
            if (c == 93) {
                c = this.readCodePoint();
                this.subject = this.createNode();
                this.skipWSC();
                this.parsePredicateObjectList();
            } else {
                this.unread(91);
                this.subject = this.parseImplicitBlank();
            }
            this.skipWSC();
            c = this.peekCodePoint();
            if (c != 46) {
                this.parsePredicateObjectList();
            }
        } else {
            this.parseSubject();
            this.skipWSC();
            this.parsePredicateObjectList();
        }
        this.subject = null;
        this.predicate = null;
        this.object = null;
    }

    protected void parsePredicateObjectList() throws IOException, RDFParseException, RDFHandlerException {
        this.predicate = this.parsePredicate();
        this.skipWSC();
        this.parseObjectList();
        while (this.skipWSC() == 59) {
            this.readCodePoint();
            int c = this.skipWSC();
            if (c == 46 || c == 93 || c == 125) break;
            if (c == 59) continue;
            this.predicate = this.parsePredicate();
            this.skipWSC();
            this.parseObjectList();
        }
    }

    protected void parseObjectList() throws IOException, RDFParseException, RDFHandlerException {
        this.parseObject();
        if (this.skipWSC() == 123) {
            this.parseAnnotation();
        }
        while (this.skipWSC() == 44) {
            this.readCodePoint();
            this.skipWSC();
            this.parseObject();
            if (this.skipWSC() != 123) continue;
            this.parseAnnotation();
        }
    }

    protected void parseSubject() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peekCodePoint();
        if (c == 40) {
            this.subject = this.parseCollection();
        } else if (c == 91) {
            this.subject = this.parseImplicitBlank();
        } else {
            Value value = this.parseValue();
            if (value instanceof Resource) {
                this.subject = (Resource)value;
            } else if (value != null) {
                this.reportFatalError("Illegal subject value: " + value);
            }
        }
    }

    protected IRI parsePredicate() throws IOException, RDFParseException, RDFHandlerException {
        int c1 = this.readCodePoint();
        if (c1 == 97) {
            int c2 = this.readCodePoint();
            if (TurtleUtil.isWhitespace(c2)) {
                return RDF.TYPE;
            }
            this.unread(c2);
        }
        this.unread(c1);
        Value predicate = this.parseValue();
        if (predicate instanceof IRI) {
            return (IRI)predicate;
        }
        this.reportFatalError("Illegal predicate value: " + predicate);
        return null;
    }

    protected void parseObject() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.peekCodePoint();
        switch (c) {
            case 40: {
                this.object = this.parseCollection();
                break;
            }
            case 91: {
                this.object = this.parseImplicitBlank();
                break;
            }
            default: {
                this.object = this.parseValue();
                this.reportStatement(this.subject, this.predicate, this.object);
            }
        }
    }

    protected Resource parseCollection() throws IOException, RDFParseException, RDFHandlerException {
        this.verifyCharacterOrFail(this.readCodePoint(), "(");
        int c = this.skipWSC();
        if (c == 41) {
            this.readCodePoint();
            if (this.subject != null) {
                this.reportStatement(this.subject, this.predicate, (Value)RDF.NIL);
            }
            return RDF.NIL;
        }
        Resource listRoot = this.createNode();
        if (this.subject != null) {
            this.reportStatement(this.subject, this.predicate, (Value)listRoot);
        }
        Resource oldSubject = this.subject;
        IRI oldPredicate = this.predicate;
        this.subject = listRoot;
        this.predicate = RDF.FIRST;
        this.parseObject();
        Resource bNode = listRoot;
        while (this.skipWSC() != 41) {
            Resource newNode = this.createNode();
            this.reportStatement(bNode, RDF.REST, (Value)newNode);
            this.subject = bNode = newNode;
            this.parseObject();
        }
        this.readCodePoint();
        this.reportStatement(bNode, RDF.REST, (Value)RDF.NIL);
        this.subject = oldSubject;
        this.predicate = oldPredicate;
        return listRoot;
    }

    protected Resource parseImplicitBlank() throws IOException, RDFParseException, RDFHandlerException {
        this.verifyCharacterOrFail(this.readCodePoint(), "[");
        Resource bNode = this.createNode();
        if (this.subject != null) {
            this.reportStatement(this.subject, this.predicate, (Value)bNode);
        }
        this.skipWSC();
        int c = this.readCodePoint();
        if (c != 93) {
            this.unread(c);
            Resource oldSubject = this.subject;
            IRI oldPredicate = this.predicate;
            this.subject = bNode;
            this.skipWSC();
            this.parsePredicateObjectList();
            this.skipWSC();
            this.verifyCharacterOrFail(this.readCodePoint(), "]");
            this.subject = oldSubject;
            this.predicate = oldPredicate;
        }
        return bNode;
    }

    protected Value parseValue() throws IOException, RDFParseException, RDFHandlerException {
        if (((Boolean)this.getParserConfig().get(TurtleParserSettings.ACCEPT_TURTLESTAR)).booleanValue() && this.peekIsTripleValue()) {
            return this.parseTripleValue();
        }
        int c = this.peekCodePoint();
        if (c == 60) {
            return this.parseURI();
        }
        if (c == 58 || TurtleUtil.isPrefixStartChar(c)) {
            return this.parseQNameOrBoolean();
        }
        if (c == 95) {
            return this.parseNodeID();
        }
        if (c == 34 || c == 39) {
            return this.parseQuotedLiteral();
        }
        if (ASCIIUtil.isNumber((int)c) || c == 46 || c == 43 || c == 45) {
            return this.parseNumber();
        }
        if (c == -1) {
            this.throwEOFException();
            return null;
        }
        this.reportFatalError("Expected an RDF value here, found '" + new String(Character.toChars(c)) + "'");
        return null;
    }

    protected Literal parseQuotedLiteral() throws IOException, RDFParseException, RDFHandlerException {
        String label = this.parseQuotedString();
        int c = this.peekCodePoint();
        if (c == 64) {
            boolean verifyLanguageTag;
            this.readCodePoint();
            StringBuilder lang = this.getBuilder();
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            }
            if ((verifyLanguageTag = ((Boolean)this.getParserConfig().get(BasicParserSettings.VERIFY_LANGUAGE_TAGS)).booleanValue()) && !TurtleUtil.isLanguageStartChar(c)) {
                this.reportError("Expected a letter, found '" + new String(Character.toChars(c)) + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            }
            TurtleParser.appendCodepoint(lang, c);
            c = this.readCodePoint();
            while (!TurtleUtil.isWhitespace(c) && c != 46 && c != 59 && c != 44 && c != 41 && c != 93 && c != 62 && c != -1) {
                if (verifyLanguageTag && !TurtleUtil.isLanguageChar(c)) {
                    this.reportError("Illegal language tag char: '" + new String(Character.toChars(c)) + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_LANGUAGE_TAGS);
                }
                TurtleParser.appendCodepoint(lang, c);
                c = this.readCodePoint();
            }
            this.unread(c);
            return this.createLiteral(label, lang.toString(), null, this.getLineNumber(), -1L);
        }
        if (c == 94) {
            this.readCodePoint();
            this.verifyCharacterOrFail(this.readCodePoint(), "^");
            this.skipWSC();
            Value datatype = this.parseValue();
            if (datatype == null) {
                this.reportError("Invalid datatype IRI for literal '" + label + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_URI_SYNTAX);
                return null;
            }
            if (!(datatype instanceof IRI)) {
                this.reportFatalError("Illegal datatype value: " + datatype);
            }
            return this.createLiteral(label, null, (IRI)datatype, this.getLineNumber(), -1L);
        }
        return this.createLiteral(label, null, null, this.getLineNumber(), -1L);
    }

    protected String parseQuotedString() throws IOException, RDFParseException {
        String result;
        int c1 = this.readCodePoint();
        this.verifyCharacterOrFail(c1, "\"'");
        int c2 = this.readCodePoint();
        int c3 = this.readCodePoint();
        if (c1 == 34 && c2 == 34 && c3 == 34 || c1 == 39 && c2 == 39 && c3 == 39) {
            result = this.parseLongString(c2);
        } else {
            this.unread(c3);
            this.unread(c2);
            result = this.parseString(c1);
        }
        try {
            result = TurtleUtil.decodeString(result);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), (RioSetting<Boolean>)BasicParserSettings.VERIFY_DATATYPE_VALUES);
        }
        return result;
    }

    protected String parseString(int closingCharacter) throws IOException, RDFParseException {
        int c;
        StringBuilder sb = this.getBuilder();
        while ((c = this.readCodePoint()) != closingCharacter) {
            if (c == -1) {
                this.throwEOFException();
            }
            if (c == 13 || c == 10) {
                this.reportFatalError("Illegal carriage return or new line in literal");
            }
            if (c == 13 || c == 10) {
                this.reportFatalError("Illegal carriage return or new line in literal");
            }
            TurtleParser.appendCodepoint(sb, c);
            if (c != 92) continue;
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            }
            TurtleParser.appendCodepoint(sb, c);
        }
        return sb.toString();
    }

    protected String parseLongString(int closingCharacter) throws IOException, RDFParseException {
        StringBuilder sb = this.getBuilder();
        int doubleQuoteCount = 0;
        while (doubleQuoteCount < 3) {
            int c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            } else {
                doubleQuoteCount = c == closingCharacter ? ++doubleQuoteCount : 0;
            }
            TurtleParser.appendCodepoint(sb, c);
            if (c == 10) {
                ++this.lineNumber;
                this.reportLocation();
            }
            if (c != 92) continue;
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            }
            TurtleParser.appendCodepoint(sb, c);
        }
        return sb.substring(0, sb.length() - 3);
    }

    protected Literal parseNumber() throws IOException, RDFParseException {
        StringBuilder value = this.getBuilder();
        IRI datatype = XSD.INTEGER;
        int c = this.readCodePoint();
        if (c == 43 || c == 45) {
            TurtleParser.appendCodepoint(value, c);
            c = this.readCodePoint();
        }
        while (ASCIIUtil.isNumber((int)c)) {
            TurtleParser.appendCodepoint(value, c);
            c = this.readCodePoint();
        }
        if (c == 46 || c == 101 || c == 69) {
            if (c == 46) {
                if (!TurtleUtil.isWhitespace(this.peekCodePoint())) {
                    TurtleParser.appendCodepoint(value, c);
                    c = this.readCodePoint();
                    while (ASCIIUtil.isNumber((int)c)) {
                        TurtleParser.appendCodepoint(value, c);
                        c = this.readCodePoint();
                    }
                    if (value.length() == 1) {
                        this.reportFatalError("Object for statement missing");
                    }
                    datatype = XSD.DECIMAL;
                }
            } else if (value.length() == 0) {
                this.reportFatalError("Object for statement missing");
            }
            if (c == 101 || c == 69) {
                datatype = XSD.DOUBLE;
                TurtleParser.appendCodepoint(value, c);
                c = this.readCodePoint();
                if (c == 43 || c == 45) {
                    TurtleParser.appendCodepoint(value, c);
                    c = this.readCodePoint();
                }
                if (!ASCIIUtil.isNumber((int)c)) {
                    this.reportError("Exponent value missing", (RioSetting<Boolean>)BasicParserSettings.VERIFY_DATATYPE_VALUES);
                }
                TurtleParser.appendCodepoint(value, c);
                c = this.readCodePoint();
                while (ASCIIUtil.isNumber((int)c)) {
                    TurtleParser.appendCodepoint(value, c);
                    c = this.readCodePoint();
                }
            }
        }
        this.unread(c);
        return this.createLiteral(value.toString(), null, datatype, this.getLineNumber(), -1L);
    }

    protected IRI parseURI() throws IOException, RDFParseException {
        StringBuilder uriBuf = this.getBuilder();
        int c = this.readCodePoint();
        this.verifyCharacterOrFail(c, "<");
        boolean uriIsIllegal = false;
        while ((c = this.readCodePoint()) != 62) {
            if (c == -1) {
                this.throwEOFException();
            }
            if (c == 32) {
                this.reportError("IRI included an unencoded space: '" + c + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_URI_SYNTAX);
                uriIsIllegal = true;
            }
            TurtleParser.appendCodepoint(uriBuf, c);
            if (c != 92) continue;
            c = this.readCodePoint();
            if (c == -1) {
                this.throwEOFException();
            }
            if (c != 117 && c != 85) {
                this.reportError("IRI includes string escapes: '\\" + c + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_URI_SYNTAX);
                uriIsIllegal = true;
            }
            TurtleParser.appendCodepoint(uriBuf, c);
        }
        if (c == 46) {
            this.reportError("IRI must not end in a '.'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_URI_SYNTAX);
            uriIsIllegal = true;
        }
        if (!uriIsIllegal || !((Boolean)this.getParserConfig().get(BasicParserSettings.VERIFY_URI_SYNTAX)).booleanValue()) {
            String uri = uriBuf.toString();
            try {
                uri = TurtleUtil.decodeString(uri);
            }
            catch (IllegalArgumentException e) {
                this.reportError(e.getMessage(), (RioSetting<Boolean>)BasicParserSettings.VERIFY_DATATYPE_VALUES);
            }
            return super.resolveURI(uri);
        }
        return null;
    }

    protected Value parseQNameOrBoolean() throws IOException, RDFParseException {
        int previousChar;
        String namespace;
        int c = this.readCodePoint();
        if (c == -1) {
            this.throwEOFException();
        }
        if (c != 58 && !TurtleUtil.isPrefixStartChar(c)) {
            this.reportError("Expected a ':' or a letter, found '" + new String(Character.toChars(c)) + "'", (RioSetting<Boolean>)BasicParserSettings.VERIFY_RELATIVE_URIS);
        }
        if (c == 58) {
            namespace = this.getNamespace("");
        } else {
            StringBuilder prefix = new StringBuilder(8);
            TurtleParser.appendCodepoint(prefix, c);
            previousChar = c;
            c = this.readCodePoint();
            while (TurtleUtil.isPrefixChar(c)) {
                TurtleParser.appendCodepoint(prefix, c);
                previousChar = c;
                c = this.readCodePoint();
            }
            while (previousChar == 46 && prefix.length() > 0) {
                this.unread(c);
                c = previousChar;
                prefix.setLength(prefix.length() - 1);
                previousChar = prefix.codePointAt(prefix.codePointCount(0, prefix.length()) - 1);
            }
            if (c != 58) {
                String value = prefix.toString();
                if (value.equals("true")) {
                    this.unread(c);
                    return this.createLiteral("true", null, (CoreDatatype)CoreDatatype.XSD.BOOLEAN, this.getLineNumber(), -1L);
                }
                if (value.equals("false")) {
                    this.unread(c);
                    return this.createLiteral("false", null, (CoreDatatype)CoreDatatype.XSD.BOOLEAN, this.getLineNumber(), -1L);
                }
            }
            this.verifyCharacterOrFail(c, ":");
            namespace = this.getNamespace(prefix.toString());
        }
        StringBuilder localName = new StringBuilder(16);
        c = this.readCodePoint();
        if (TurtleUtil.isNameStartChar(c)) {
            if (c == 92) {
                localName.append(this.readLocalEscapedChar());
            } else {
                TurtleParser.appendCodepoint(localName, c);
            }
            previousChar = c;
            c = this.readCodePoint();
            while (TurtleUtil.isNameChar(c)) {
                if (c == 92) {
                    localName.append(this.readLocalEscapedChar());
                } else {
                    TurtleParser.appendCodepoint(localName, c);
                }
                previousChar = c;
                c = this.readCodePoint();
            }
            this.unread(c);
            if (previousChar == 46) {
                this.unread(previousChar);
                localName.deleteCharAt(localName.length() - 1);
            }
        } else {
            this.unread(c);
        }
        String localNameString = localName.toString();
        for (int i = 0; i < localNameString.length(); ++i) {
            if (localNameString.charAt(i) != '%' || i <= localNameString.length() - 3 && ASCIIUtil.isHex((int)localNameString.charAt(i + 1)) && ASCIIUtil.isHex((int)localNameString.charAt(i + 2))) continue;
            this.reportFatalError("Found incomplete percent-encoded sequence: " + localNameString);
        }
        return this.createURI(namespace + localNameString);
    }

    private char readLocalEscapedChar() throws RDFParseException, IOException {
        int c = this.readCodePoint();
        if (TurtleUtil.isLocalEscapedChar(c)) {
            return (char)c;
        }
        throw new RDFParseException("found '" + new String(Character.toChars(c)) + "', expected one of: " + Arrays.toString(TurtleUtil.LOCAL_ESCAPED_CHARS));
    }

    protected Resource parseNodeID() throws IOException, RDFParseException {
        this.verifyCharacterOrFail(this.readCodePoint(), "_");
        this.verifyCharacterOrFail(this.readCodePoint(), ":");
        int c = this.readCodePoint();
        if (c == -1) {
            this.throwEOFException();
        } else if (!TurtleUtil.isBLANK_NODE_LABEL_StartChar(c)) {
            this.reportError("Expected a letter, found '" + (char)c + "'", (RioSetting<Boolean>)BasicParserSettings.PRESERVE_BNODE_IDS);
        }
        StringBuilder name = this.getBuilder();
        TurtleParser.appendCodepoint(name, c);
        c = this.readCodePoint();
        if (!TurtleUtil.isBLANK_NODE_LABEL_Char(c)) {
            this.unread(c);
        }
        while (TurtleUtil.isBLANK_NODE_LABEL_Char(c)) {
            int previous = c;
            c = this.readCodePoint();
            if (previous == 46 && (c == -1 || TurtleUtil.isWhitespace(c) || c == 60 || c == 95)) {
                this.unread(c);
                this.unread(previous);
                break;
            }
            TurtleParser.appendCodepoint(name, previous);
            if (TurtleUtil.isBLANK_NODE_LABEL_Char(c)) continue;
            this.unread(c);
        }
        return this.createNode(name.toString());
    }

    protected void reportStatement(Resource subj, IRI pred, Value obj) throws RDFParseException, RDFHandlerException {
        if (subj != null && pred != null && obj != null) {
            this.previousStatement = this.createStatement(subj, pred, obj);
            if (this.rdfHandler != null) {
                this.rdfHandler.handleStatement(this.previousStatement);
            }
        }
    }

    protected void verifyCharacterOrFail(int codePoint, String expected) throws RDFParseException {
        String supplied;
        if (codePoint == -1) {
            this.throwEOFException();
        }
        if (expected.indexOf(supplied = new String(Character.toChars(codePoint))) == -1) {
            StringBuilder msg = new StringBuilder(32);
            msg.append("Expected ");
            for (int i = 0; i < expected.length(); ++i) {
                if (i > 0) {
                    msg.append(" or ");
                }
                msg.append('\'');
                msg.append(expected.charAt(i));
                msg.append('\'');
            }
            msg.append(", found '");
            msg.append(supplied);
            msg.append("'");
            this.reportFatalError(msg.toString());
        }
    }

    protected int skipWSC() throws IOException, RDFHandlerException {
        int c = this.readCodePoint();
        while (TurtleUtil.isWhitespace(c) || c == 35) {
            if (c == 35) {
                this.processComment();
            } else if (c == 10) {
                ++this.lineNumber;
                this.reportLocation();
            }
            c = this.readCodePoint();
        }
        this.unread(c);
        return c;
    }

    protected void processComment() throws IOException, RDFHandlerException {
        StringBuilder comment = this.getBuilder();
        int c = this.readCodePoint();
        while (c != -1 && c != 13 && c != 10) {
            TurtleParser.appendCodepoint(comment, c);
            c = this.readCodePoint();
        }
        if (c == 10) {
            ++this.lineNumber;
        }
        if (c == 13) {
            c = this.readCodePoint();
            ++this.lineNumber;
            if (c != 10) {
                this.unread(c);
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.handleComment(comment.toString());
        }
        this.reportLocation();
    }

    protected int readCodePoint() throws IOException {
        int next = this.reader.read();
        if (Character.isHighSurrogate((char)next)) {
            next = Character.toCodePoint((char)next, (char)this.reader.read());
        }
        return next;
    }

    protected void unread(int codePoint) throws IOException {
        if (codePoint != -1) {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogatePair = Character.toChars(codePoint);
                this.reader.unread(surrogatePair);
            } else {
                this.reader.unread(codePoint);
            }
        }
    }

    protected void unread(String string) throws IOException {
        int i = string.length();
        while (i > 0) {
            int codePoint = string.codePointBefore(i);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogatePair = Character.toChars(codePoint);
                this.reader.unread(surrogatePair);
                i -= surrogatePair.length;
                continue;
            }
            this.reader.unread(codePoint);
            --i;
        }
    }

    protected int peekCodePoint() throws IOException {
        int result = this.readCodePoint();
        this.unread(result);
        return result;
    }

    protected void reportLocation() {
        this.reportLocation(this.getLineNumber(), -1L);
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.getLineNumber(), -1L);
    }

    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, this.getLineNumber(), -1L, setting);
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.getLineNumber(), -1L);
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.getLineNumber(), -1L);
    }

    protected void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    private StringBuilder getBuilder() {
        this.parsingBuilder.setLength(0);
        return this.parsingBuilder;
    }

    private static void appendCodepoint(StringBuilder dst, int codePoint) {
        if (Character.isBmpCodePoint(codePoint)) {
            dst.append((char)codePoint);
        } else if (Character.isValidCodePoint(codePoint)) {
            dst.append(Character.highSurrogate(codePoint));
            dst.append(Character.lowSurrogate(codePoint));
        } else {
            throw new IllegalArgumentException("Invalid codepoint " + codePoint);
        }
    }

    protected boolean peekIsTripleValue() throws IOException {
        int c0 = this.readCodePoint();
        int c1 = this.readCodePoint();
        this.unread(c1);
        this.unread(c0);
        return c0 == 60 && c1 == 60;
    }

    protected Triple parseTripleValue() throws IOException {
        this.verifyCharacterOrFail(this.readCodePoint(), "<");
        this.verifyCharacterOrFail(this.readCodePoint(), "<");
        this.skipWSC();
        Value subject = this.parseValue();
        if (subject instanceof Resource) {
            this.skipWSC();
            Value predicate = this.parseValue();
            if (predicate instanceof IRI) {
                this.skipWSC();
                Value object = this.parseValue();
                if (object != null) {
                    this.skipWSC();
                    this.verifyCharacterOrFail(this.readCodePoint(), ">");
                    this.verifyCharacterOrFail(this.readCodePoint(), ">");
                    return this.valueFactory.createTriple((Resource)subject, (IRI)predicate, object);
                }
                this.reportFatalError("Missing object in RDF-star triple");
            } else {
                this.reportFatalError("Illegal predicate value in RDF-star triple: " + predicate);
            }
        } else {
            this.reportFatalError("Illegal subject val in RDF-star triple: " + subject);
        }
        return null;
    }

    protected void parseAnnotation() throws IOException {
        this.verifyCharacterOrFail(this.readCodePoint(), "{");
        this.verifyCharacterOrFail(this.readCodePoint(), "|");
        this.skipWSC();
        Resource currentSubject = this.subject;
        IRI currentPredicate = this.predicate;
        this.subject = Values.triple((Statement)this.previousStatement);
        this.parsePredicateObjectList();
        this.verifyCharacterOrFail(this.readCodePoint(), "|");
        this.verifyCharacterOrFail(this.readCodePoint(), "}");
        this.subject = currentSubject;
        this.predicate = currentPredicate;
    }
}

