/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterByPredicate;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetObjectsOf
extends Target {
    private final Set<IRI> targetObjectsOf;

    public TargetObjectsOf(Set<IRI> targetObjectsOf) {
        this.targetObjectsOf = targetObjectsOf;
        assert (!this.targetObjectsOf.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_OBJECTS_OF;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetObjectsOf.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.targetObjectsOf.stream().map(predicate -> new UnorderedSelect(connection, null, (IRI)predicate, null, dataGraph, UnorderedSelect.Mapper.ObjectScopedMapper.getFunction(scope), null)).reduce((xva$0, xva$1) -> UnionNode.getInstance(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(planNode, false);
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new FilterByPredicate(connectionsGroup.getBaseConnection(), this.targetObjectsOf, parent, FilterByPredicate.On.Object, dataGraph);
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        assert (subject == null);
        StatementMatcher.Variable<Value> tempVar = stableRandomVariableProvider.next();
        List<StatementMatcher> statementMatchers = this.targetObjectsOf.stream().map(t -> new StatementMatcher(tempVar, new StatementMatcher.Variable<IRI>((IRI)t), object, this, Set.of())).collect(Collectors.toList());
        if (this.targetObjectsOf.size() == 1) {
            String queryFragment = this.targetObjectsOf.stream().map(t -> tempVar.asSparqlVariable() + " <" + t + "> " + object.asSparqlVariable() + " .").reduce((a, b) -> a + "\n" + b).orElse("");
            return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
        }
        String in = this.targetObjectsOf.stream().map(t -> "<" + t + ">").reduce((a, b) -> a + " , " + b).orElse("");
        StatementMatcher.Variable<Value> tempVarForIn = stableRandomVariableProvider.next();
        String queryFragment = tempVar.asSparqlVariable() + " " + tempVarForIn.asSparqlVariable() + object.asSparqlVariable() + " .\nFILTER(" + tempVarForIn.asSparqlVariable() + " in (" + in + "))";
        return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetObjectsOf that = (TargetObjectsOf)o;
        return this.targetObjectsOf.equals(that.targetObjectsOf);
    }

    public int hashCode() {
        return Objects.hash(this.targetObjectsOf) + "TargetObjectsOf".hashCode();
    }
}

