/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class Sort
implements PlanNode {
    private final PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Sort(PlanNode parent) {
        this.parent = PlanNodeHelper.handleSorting(this, parent);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            List<ValidationTuple> sortedTuples;
            Iterator<ValidationTuple> sortedTuplesIterator;

            @Override
            protected void init() {
                boolean alreadySorted;
                assert (this.sortedTuples == null);
                try (CloseableIteration<? extends ValidationTuple> iterator = Sort.this.parent.iterator();){
                    this.sortedTuples = new ArrayList<ValidationTuple>(1);
                    alreadySorted = true;
                    ValidationTuple prev = null;
                    while (iterator.hasNext()) {
                        ValidationTuple next = (ValidationTuple)iterator.next();
                        this.sortedTuples.add(next);
                        if (this.sortedTuples.size() == 1 && !iterator.hasNext()) {
                            this.sortedTuplesIterator = this.sortedTuples.iterator();
                            return;
                        }
                        if (prev != null && prev.compareActiveTarget(next) > 0) {
                            alreadySorted = false;
                        }
                        prev = next;
                    }
                    assert (!iterator.hasNext()) : "Iterator: " + iterator;
                }
                if (!alreadySorted && this.sortedTuples.size() > 1) {
                    if (this.sortedTuples.size() > 8192) {
                        ValidationTuple[] objects = this.sortedTuples.toArray(new ValidationTuple[0]);
                        Arrays.parallelSort(objects, ValidationTuple::compareActiveTarget);
                        this.sortedTuples = Arrays.asList(objects);
                    } else {
                        this.sortedTuples.sort(ValidationTuple::compareActiveTarget);
                    }
                }
                this.sortedTuplesIterator = this.sortedTuples.iterator();
            }

            @Override
            protected boolean localHasNext() {
                return this.sortedTuplesIterator.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() {
                return this.sortedTuplesIterator.next();
            }

            @Override
            public void localClose() {
                this.sortedTuplesIterator = Collections.emptyIterator();
                this.sortedTuples = null;
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort sort = (Sort)o;
        return this.parent.equals(sort.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public String toString() {
        return "Sort{parent=" + this.parent + "}";
    }
}

