/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;

public class ValueInFilter
extends FilterPlanNode {
    private final Set<Value> valueSet;

    public ValueInFilter(PlanNode parent, Set<Value> valueSet) {
        super(parent);
        this.valueSet = valueSet;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        return this.valueSet.contains(t.get().getValue());
    }

    @Override
    public String toString() {
        return "ValueInFilter{valueSet=" + Arrays.toString(this.valueSet.stream().map(Formatter::prefix).toArray()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueInFilter that = (ValueInFilter)o;
        return this.valueSet.equals(that.valueSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valueSet);
    }
}

