/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.PassThroughTupleExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStatistics;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.evaluation.iterator.StopRemainingExecutionsOnCloseIteration;
import org.eclipse.rdf4j.federated.evaluation.union.SynchronousWorkerUnion;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConnection;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.write.WriteStrategy;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXConnection
extends AbstractSailConnection {
    private static final Logger log = LoggerFactory.getLogger(FedXConnection.class);
    protected final FedX federation;
    protected final FederationContext federationContext;
    private WriteStrategy writeStrategy;

    public FedXConnection(FedX federation, FederationContext federationContext) throws SailException {
        super((AbstractSail)federation);
        this.federation = federation;
        this.federationContext = federationContext;
    }

    public void setTransactionSettings(TransactionSetting ... settings) {
        super.setTransactionSettings(settings);
        this.getWriteStrategyInternal().setTransactionSettings(settings);
    }

    protected CloseableIteration<? extends BindingSet> evaluateInternal(TupleExpr query, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr originalQuery = query;
        FederationEvalStrategy strategy = this.federationContext.createStrategy(dataset);
        long start = 0L;
        String queryString = FedXConnection.getOriginalQueryString(bindings);
        if (queryString == null) {
            log.warn("Query string is null. Please check your FedX setup.");
        }
        QueryInfo queryInfo = new QueryInfo(queryString, FedXConnection.getOriginalBaseURI(bindings), FedXConnection.getOriginalQueryType(bindings), FedXConnection.getOriginalMaxExecutionTime(bindings), includeInferred, this.federationContext, strategy, dataset);
        if (query instanceof PassThroughTupleExpr) {
            PassThroughTupleExpr node = (PassThroughTupleExpr)query;
            queryInfo.setResultHandler(node.getResultHandler());
            query = node.getExpr();
        }
        if (log.isDebugEnabled()) {
            log.debug("Optimization start (Query: " + queryInfo.getQueryID() + ")");
            start = System.currentTimeMillis();
        }
        try {
            this.federationContext.getMonitoringService().monitorQuery(queryInfo);
            FederationEvaluationStatistics stats = new FederationEvaluationStatistics(queryInfo, dataset);
            query = strategy.optimize(query, stats, bindings);
        }
        catch (Exception e) {
            log.warn("Exception occured during optimization (Query: " + queryInfo.getQueryID() + "): " + e.getMessage());
            log.debug("Details: ", (Throwable)e);
            throw new SailException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Optimization duration: " + (System.currentTimeMillis() - start) + " (Query: " + queryInfo.getQueryID() + ")");
        }
        this.federationContext.getMonitoringService().logQueryPlan(query);
        if (this.federationContext.getConfig().isDebugQueryPlan()) {
            System.out.println("Optimized query execution plan: \n" + query);
        }
        if (log.isDebugEnabled()) {
            log.debug("Optimized query execution plan (Query: " + queryInfo.getQueryID() + ");" + query);
        }
        try {
            BindingSet queryBindings = EmptyBindingSet.getInstance();
            if (!FedXRepositoryConnection.FEDX_BINDINGS.containsAll(bindings.getBindingNames())) {
                MapBindingSet actualQueryBindings = new MapBindingSet();
                bindings.forEach(binding -> {
                    if (!FedXRepositoryConnection.FEDX_BINDINGS.contains(binding.getName())) {
                        actualQueryBindings.addBinding(binding);
                    }
                });
                queryBindings = actualQueryBindings;
            }
            CloseableIteration<BindingSet> res = null;
            try {
                res = strategy.evaluate(query, queryBindings);
                if (originalQuery instanceof PassThroughTupleExpr && res instanceof EmptyIteration) {
                    ((PassThroughTupleExpr)originalQuery).setPassedThrough(true);
                }
                return new StopRemainingExecutionsOnCloseIteration(res, queryInfo);
            }
            catch (Throwable t) {
                if (res != null) {
                    res.close();
                }
                throw t;
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        try {
            this.getWriteStrategyInternal().clear(contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void clearNamespacesInternal() throws SailException {
        try {
            this.getWriteStrategyInternal().clearNamespaces();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void closeInternal() throws SailException {
        try {
            if (this.writeStrategy != null) {
                this.writeStrategy.close();
            }
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void commitInternal() throws SailException {
        try {
            this.getWriteStrategyInternal().commit();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Resource> getContextIDsInternal() throws SailException {
        FederationEvalStrategy strategy = this.federationContext.createStrategy((Dataset)new SimpleDataset());
        final SynchronousWorkerUnion<Resource> union = new SynchronousWorkerUnion<Resource>(new QueryInfo("getContextIDsInternal", null, QueryType.UNKNOWN, 0, this.federationContext.getConfig().getIncludeInferredDefault(), this.federationContext, strategy, (Dataset)new SimpleDataset()));
        for (final Endpoint e : this.federation.getMembers()) {
            union.addTask(new ParallelTask<Resource>(){

                @Override
                public CloseableIteration<Resource> performTask() {
                    try (RepositoryConnection conn = e.getConnection();){
                        CollectionIteration collectionIteration = new CollectionIteration((Collection)Iterations.asList((CloseableIteration)conn.getContextIDs()));
                        return collectionIteration;
                    }
                }

                @Override
                public ParallelExecutor<Resource> getControl() {
                    return union;
                }

                @Override
                public void cancel() {
                }
            });
        }
        this.federationContext.getManager().getExecutor().execute(union);
        final CollectionFactory cf = this.federation.getCollectionFactory().get();
        ExceptionConvertingIteration<Resource, SailException> conv = new ExceptionConvertingIteration<Resource, SailException>(union){

            protected SailException convert(RuntimeException e) {
                return new SailException((Throwable)e);
            }
        };
        return new DistinctIteration<Resource>((CloseableIteration)conv, () -> ((CollectionFactory)cf).createSet()){

            protected void handleClose() {
                try {
                    cf.close();
                }
                finally {
                    super.handleClose();
                }
            }
        };
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        return null;
    }

    protected CloseableIteration<? extends Namespace> getNamespacesInternal() throws SailException {
        return new EmptyIteration();
    }

    protected CloseableIteration<? extends Statement> getStatementsInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        try {
            SimpleDataset dataset = new SimpleDataset();
            FederationEvalStrategy strategy = this.federationContext.createStrategy((Dataset)dataset);
            QueryInfo queryInfo = new QueryInfo(subj, pred, obj, 0, includeInferred, this.federationContext, strategy, (Dataset)dataset);
            this.federationContext.getMonitoringService().monitorQuery(queryInfo);
            CloseableIteration<Statement> res = null;
            try {
                res = strategy.getStatements(queryInfo, subj, pred, obj, contexts);
                return new ExceptionConvertingIteration<Statement, RuntimeException>(res){

                    protected SailException convert(RuntimeException e) {
                        return new SailException((Throwable)e);
                    }
                };
            }
            catch (Throwable t) {
                if (res != null) {
                    res.close();
                }
                throw t;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new SailException((Throwable)e);
        }
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.getWriteStrategyInternal().addStatement(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            this.getWriteStrategyInternal().removeStatement(subj, pred, obj, contexts);
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void rollbackInternal() throws SailException {
        try {
            this.getWriteStrategyInternal().rollback();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        if (contexts != null && contexts.length > 0) {
            throw new UnsupportedOperationException("Context handling for size() not supported");
        }
        long size = 0L;
        ArrayList<String> errorEndpoints = new ArrayList<String>();
        for (Endpoint e : this.federation.getMembers()) {
            try {
                size += e.size();
            }
            catch (RepositoryException e1) {
                errorEndpoints.add(e.getId());
            }
        }
        if (!errorEndpoints.isEmpty()) {
            throw new SailException("Could not determine size for members " + errorEndpoints + "(Supported for NativeStore and RemoteRepository only). Computed size: " + size);
        }
        return size;
    }

    protected void startTransactionInternal() throws SailException {
        try {
            this.getWriteStrategyInternal().begin();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected synchronized WriteStrategy getWriteStrategyInternal() throws SailException {
        if (this.writeStrategy == null) {
            this.writeStrategy = this.federation.getWriteStrategy();
        }
        return this.writeStrategy;
    }

    private static String getOriginalQueryString(BindingSet b) {
        if (b == null) {
            return null;
        }
        Value q = b.getValue("__originalQuery");
        if (q != null) {
            return q.stringValue();
        }
        return null;
    }

    private static String getOriginalBaseURI(BindingSet b) {
        if (b == null) {
            return null;
        }
        return Literals.getLabel((Value)b.getValue("__originalBaseURI"), null);
    }

    private static QueryType getOriginalQueryType(BindingSet b) {
        if (b == null) {
            return null;
        }
        Value q = b.getValue("__originalQueryType");
        if (q != null) {
            return QueryType.valueOf(q.stringValue());
        }
        return null;
    }

    private static int getOriginalMaxExecutionTime(BindingSet b) {
        if (b == null) {
            return 0;
        }
        Value q = b.getValue("__originalQueryMaxExecutionTime");
        if (q != null) {
            return Integer.parseInt(q.stringValue());
        }
        return 0;
    }

    public Explanation explain(Explanation.Level level, TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred, int timeoutSeconds) {
        throw new UnsupportedOperationException();
    }

    protected static class SailBaseDefaultImpl
    extends AbstractSail {
        protected SailBaseDefaultImpl() {
        }

        protected SailConnection getConnectionInternal() throws SailException {
            return null;
        }

        protected void shutDownInternal() throws SailException {
        }

        public ValueFactory getValueFactory() {
            return FedXUtil.valueFactory();
        }

        public boolean isWritable() throws SailException {
            return false;
        }

        protected void connectionClosed(SailConnection connection) {
        }
    }
}

