/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterByPredicate;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetSubjectsOf
extends Target {
    private final Set<IRI> targetSubjectsOf;

    public TargetSubjectsOf(Set<IRI> targetSubjectsOf) {
        this.targetSubjectsOf = targetSubjectsOf;
        assert (!this.targetSubjectsOf.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_SUBJECTS_OF;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetSubjectsOf.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope, connectionsGroup);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope, ConnectionsGroup connectionsGroup) {
        PlanNode planNode = this.targetSubjectsOf.stream().map(predicate -> new UnorderedSelect(connection, null, (IRI)predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope), null)).reduce((nodes, nodes2) -> UnionNode.getInstance(connectionsGroup, nodes, nodes2)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(planNode, false, connectionsGroup);
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new FilterByPredicate(connectionsGroup.getBaseConnection(), this.targetSubjectsOf, parent, FilterByPredicate.On.Subject, dataGraph, connectionsGroup);
    }

    @Override
    public SparqlFragment getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, Set<String> inheritedVarNames) {
        assert (subject == null);
        StatementMatcher.Variable<Value> tempVar = stableRandomVariableProvider.next();
        List<StatementMatcher> statementMatchers = this.targetSubjectsOf.stream().map(t -> new StatementMatcher(object, new StatementMatcher.Variable<IRI>((IRI)t), tempVar, this, Set.of())).collect(Collectors.toList());
        if (this.targetSubjectsOf.size() == 1) {
            String queryFragment = this.targetSubjectsOf.stream().map(t -> object.asSparqlVariable() + " <" + t + "> " + tempVar.asSparqlVariable() + " .").reduce((a, b) -> a + "\n" + b).orElse("");
            return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
        }
        String in = this.targetSubjectsOf.stream().map(t -> "<" + t + ">").reduce((a, b) -> a + " , " + b).orElse("");
        StatementMatcher.Variable<Value> tempVarForIn = stableRandomVariableProvider.next();
        String queryFragment = object.asSparqlVariable() + " " + tempVarForIn.asSparqlVariable() + tempVar.asSparqlVariable() + " .\nFILTER(" + tempVarForIn.asSparqlVariable() + " in (" + in + "))";
        return SparqlFragment.bgp(List.of(), queryFragment, statementMatchers);
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetSubjectsOf that = (TargetSubjectsOf)o;
        return this.targetSubjectsOf.equals(that.targetSubjectsOf);
    }

    public int hashCode() {
        return Objects.hash(this.targetSubjectsOf) + "TargetSubjectsOf".hashCode();
    }
}

