/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.Targetable;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.InversePath;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AllTargetsPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BindSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterByQuery;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TupleMapper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.RSXTargetShape;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChainRetriever;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class EffectiveTarget {
    public static final String TARGET_VAR_PREFIX = "target_";
    public static final String[] TARGET_NAMES = (String[])IntStream.range(0, 1000).mapToObj(i -> TARGET_VAR_PREFIX + String.format("%010d", i)).map(String::intern).toArray(String[]::new);
    private final ArrayDeque<EffectiveTargetFragment> chain;
    private final EffectiveTargetFragment optional;

    public EffectiveTarget(ArrayDeque<Targetable> chain, Targetable optional, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        int index = 0;
        this.chain = new ArrayDeque();
        EffectiveTargetFragment previous = null;
        for (Targetable targetable : chain) {
            EffectiveTargetFragment effectiveTargetFragment;
            previous = effectiveTargetFragment = new EffectiveTargetFragment(new StatementMatcher.Variable<String>(this.getTargetVarName(index++)), targetable, previous, rdfsSubClassOfReasoner, stableRandomVariableProvider);
            this.chain.addLast(effectiveTargetFragment);
        }
        this.optional = optional != null ? new EffectiveTargetFragment(new StatementMatcher.Variable<String>(this.getTargetVarName(index)), optional, previous, rdfsSubClassOfReasoner, stableRandomVariableProvider) : null;
    }

    private String getTargetVarName(int i) {
        if (i < TARGET_NAMES.length) {
            return TARGET_NAMES[i];
        }
        return TARGET_VAR_PREFIX + String.format("%010d", i);
    }

    public StatementMatcher.Variable<Value> getTargetVar() {
        return this.chain.getLast().var;
    }

    public PlanNode extend(PlanNode source, ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, Extend direction, boolean includePropertyShapeValues, Function<PlanNode, PlanNode> filter) {
        if (source instanceof AllTargetsPlanNode && !includePropertyShapeValues) {
            PlanNode allTargets = this.getAllTargets(connectionsGroup, dataGraph, scope);
            if (filter != null) {
                allTargets = filter.apply(allTargets);
            }
            return allTargets;
        }
        List<StatementMatcher.Variable<Value>> vars = this.getVars(includePropertyShapeValues);
        List<String> varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        if (varNames.size() == 1) {
            PlanNode parent = new TupleMapper(source, new ActiveTargetTupleMapper(scope, includePropertyShapeValues, dataGraph), connectionsGroup);
            if (filter != null) {
                parent = filter.apply(parent);
            }
            return connectionsGroup.getCachedNodeFor(this.getTargetFilter(connectionsGroup, dataGraph, Unique.getInstance(parent, false, connectionsGroup)));
        }
        SparqlFragment query = this.getQueryFragment(includePropertyShapeValues);
        PlanNode parent = new BindSelect(connectionsGroup.getBaseConnection(), dataGraph, query, vars, source, varNames, scope, 1000, direction, includePropertyShapeValues, connectionsGroup);
        if (filter != null) {
            parent = connectionsGroup.getCachedNodeFor(parent);
            parent = filter.apply(parent);
            parent = Unique.getInstance(parent, true, connectionsGroup);
            return parent;
        }
        return connectionsGroup.getCachedNodeFor(Unique.getInstance(parent, true, connectionsGroup));
    }

    private List<StatementMatcher.Variable<Value>> getVars(boolean optional) {
        int chainSize = this.chain.size();
        if (chainSize == 1) {
            if (optional) {
                return List.of(this.chain.getFirst().var, this.optional.var);
            }
            return List.of(this.chain.getFirst().var);
        }
        if (chainSize == 2) {
            if (optional) {
                return List.of(this.chain.getFirst().var, this.chain.getLast().var, this.optional.var);
            }
            return List.of(this.chain.getFirst().var, this.chain.getLast().var);
        }
        if (optional) {
            return Stream.concat(this.chain.stream(), Stream.of(this.optional)).map(t -> t.var).collect(Collectors.toList());
        }
        return this.chain.stream().map(t -> t.var).collect(Collectors.toList());
    }

    public boolean couldMatch(ConnectionsGroup connectionsGroup, Resource[] dataGraph) {
        if (this.optional != null && this.optional.target instanceof TargetNode) {
            return true;
        }
        for (EffectiveTargetFragment e : this.chain) {
            if (e.target instanceof TargetNode) {
                return true;
            }
            if (e.getQueryFragment().supportsIncrementalEvaluation()) continue;
            return true;
        }
        SailConnection addedStatements = connectionsGroup.getAddedStatements();
        SailConnection removedStatements = connectionsGroup.getRemovedStatements();
        if (this.optional != null) {
            List<StatementMatcher> statementMatchers = this.optional.getQueryFragment().getStatementMatchers();
            for (StatementMatcher currentStatementPattern : statementMatchers) {
                boolean match = addedStatements.hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph) || removedStatements.hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph);
                if (!match) continue;
                return true;
            }
        }
        for (EffectiveTargetFragment effectiveTargetFragment : this.chain) {
            List<StatementMatcher> statementMatchers = effectiveTargetFragment.getQueryFragment().getStatementMatchers();
            for (StatementMatcher currentStatementPattern : statementMatchers) {
                boolean match = addedStatements.hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph) || removedStatements.hasStatement(currentStatementPattern.getSubjectValue(), currentStatementPattern.getPredicateValue(), currentStatementPattern.getObjectValue(), false, dataGraph);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    public PlanNode getAllTargets(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return new AllTargetsPlanNode(connectionsGroup.getBaseConnection(), dataGraph, this.chain, this.getVars(false), scope);
    }

    public PlanNode getPlanNode(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, boolean includeTargetsAffectedByRemoval, Function<PlanNode, PlanNode> filter) {
        PlanNode targetsPlanNode;
        assert (!this.chain.isEmpty());
        boolean bl = includeTargetsAffectedByRemoval = includeTargetsAffectedByRemoval && connectionsGroup.getStats().hasRemoved();
        if (!(this.chain.size() != 1 || includeTargetsAffectedByRemoval && this.optional != null)) {
            EffectiveTargetFragment last = this.chain.getLast();
            if (last.target instanceof Target) {
                if (filter != null) {
                    return filter.apply(connectionsGroup.getCachedNodeFor(((Target)last.target).getAdded(connectionsGroup, dataGraph, scope)));
                }
                return connectionsGroup.getCachedNodeFor(((Target)last.target).getAdded(connectionsGroup, dataGraph, scope));
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        List<SparqlFragment> sparqlFragments = this.chain.stream().map(EffectiveTargetFragment::getQueryFragment).collect(Collectors.toList());
        SparqlFragment fragment = SparqlFragment.join(sparqlFragments);
        if (fragment.supportsIncrementalEvaluation()) {
            List<Object> statementMatchersRemoval;
            List<StatementMatcher> statementMatchers = sparqlFragments.stream().flatMap(sparqlFragment -> sparqlFragment.getStatementMatchers().stream()).collect(Collectors.toList());
            List<Object> list = statementMatchersRemoval = this.optional != null ? this.optional.getQueryFragment().getStatementMatchers() : new ArrayList();
            if (this.chain.getFirst().target instanceof RSXTargetShape) {
                statementMatchersRemoval.addAll(sparqlFragments.get(0).getStatementMatchers());
                includeTargetsAffectedByRemoval = true;
            }
            targetsPlanNode = includeTargetsAffectedByRemoval ? new TargetChainRetriever(connectionsGroup, dataGraph, statementMatchers, statementMatchersRemoval, this.optional, fragment, this.getVars(false), scope, false) : new TargetChainRetriever(connectionsGroup, dataGraph, statementMatchers, null, null, fragment, this.getVars(false), scope, false);
        } else {
            targetsPlanNode = new AllTargetsPlanNode(connectionsGroup.getBaseConnection(), dataGraph, this.chain, this.getVars(false), scope);
        }
        if (filter != null) {
            if (this.chain.size() > 1) {
                return connectionsGroup.getCachedNodeFor(Unique.getInstance(filter.apply(targetsPlanNode), true, connectionsGroup));
            }
            return connectionsGroup.getCachedNodeFor(filter.apply(targetsPlanNode));
        }
        if (this.chain.size() > 1) {
            return connectionsGroup.getCachedNodeFor(Unique.getInstance(targetsPlanNode, true, connectionsGroup));
        }
        return connectionsGroup.getCachedNodeFor(targetsPlanNode);
    }

    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        EffectiveTargetFragment last = this.chain.getLast();
        if (this.chain.size() == 1) {
            if (last.target instanceof Target) {
                return ((Target)last.target).getTargetFilter(connectionsGroup, dataGraph, parent);
            }
            throw new ShaclUnsupportedException("Unknown target in chain is type: " + last.getClass().getSimpleName());
        }
        List<SparqlFragment> collect = this.chain.stream().map(EffectiveTargetFragment::getQueryFragment).collect(Collectors.toList());
        SparqlFragment sparqlFragment = SparqlFragment.join(collect);
        return new ExternalFilterByQuery(connectionsGroup.getBaseConnection(), dataGraph, parent, sparqlFragment, last.var, ValidationTuple::getActiveTarget, null, connectionsGroup).getTrueNode(UnBufferedPlanNode.class);
    }

    public String getQuery(boolean includeOptional) {
        ArrayDeque<EffectiveTargetFragment> chain;
        if (includeOptional) {
            chain = new ArrayDeque<EffectiveTargetFragment>(this.chain);
            chain.addLast(this.optional);
        } else {
            chain = this.chain;
        }
        return chain.stream().map(EffectiveTargetFragment::getQueryFragment).map(SparqlFragment::getFragment).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    public SparqlFragment getQueryFragment(boolean includeOptional) {
        ArrayDeque<EffectiveTargetFragment> chain;
        if (includeOptional) {
            chain = new ArrayDeque<EffectiveTargetFragment>(this.chain);
            chain.addLast(this.optional);
        } else {
            chain = this.chain;
        }
        if (chain.size() == 1) {
            return chain.getFirst().getQueryFragment();
        }
        List<SparqlFragment> collect = chain.stream().map(EffectiveTargetFragment::getQueryFragment).collect(Collectors.toList());
        return SparqlFragment.join(collect);
    }

    public List<StatementMatcher.Variable<Value>> getAllTargetVariables() {
        return this.chain.stream().map(c -> c.var).collect(Collectors.toCollection(ArrayList::new));
    }

    public StatementMatcher.Variable<Value> getOptionalVar() {
        return Objects.requireNonNull(this.optional, (String)"Optional was null").var;
    }

    public int size() {
        return this.chain.size();
    }

    static class ActiveTargetTupleMapper
    implements Function<ValidationTuple, ValidationTuple> {
        private final ConstraintComponent.Scope scope;
        private final boolean includePropertyShapeValues;
        private final Resource[] dataGraph;

        public ActiveTargetTupleMapper(ConstraintComponent.Scope scope, boolean includePropertyShapeValues, Resource[] dataGraph) {
            this.scope = scope;
            this.includePropertyShapeValues = includePropertyShapeValues;
            this.dataGraph = dataGraph;
        }

        @Override
        public ValidationTuple apply(ValidationTuple validationTuple) {
            return new ValidationTuple(validationTuple.getActiveTarget(), this.scope, this.includePropertyShapeValues, this.dataGraph);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActiveTargetTupleMapper that = (ActiveTargetTupleMapper)o;
            return this.includePropertyShapeValues == that.includePropertyShapeValues && this.scope == that.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scope, this.includePropertyShapeValues});
        }
    }

    public static class StatementsAndMatcher {
        private final List<Statement> statements;
        private final StatementMatcher statementMatcher;

        public StatementsAndMatcher(List<Statement> statements, StatementMatcher statementMatcher) {
            this.statements = statements;
            this.statementMatcher = statementMatcher;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public StatementMatcher getStatementMatcher() {
            return this.statementMatcher;
        }

        public boolean hasStatements() {
            return !this.statements.isEmpty();
        }

        public String toString() {
            return "StatementsAndMatcher{statements=" + Arrays.toString(this.statements.toArray()) + ", statementMatcher=" + this.statementMatcher + "}";
        }
    }

    public static class EffectiveTargetFragment {
        private final StatementMatcher.Variable<Value> var;
        private final Targetable target;
        private final SparqlFragment queryFragment;
        private final StatementMatcher rootStatementMatcher;
        private final EffectiveTargetFragment prev;

        public EffectiveTargetFragment(StatementMatcher.Variable<Value> var, Targetable target, EffectiveTargetFragment prev, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
            this.var = var;
            this.target = target;
            this.prev = prev;
            this.queryFragment = prev == null ? this.target.getTargetQueryFragment(null, this.var, rdfsSubClassOfReasoner, stableRandomVariableProvider, Set.of()) : this.target.getTargetQueryFragment(prev.var, this.var, rdfsSubClassOfReasoner, stableRandomVariableProvider, Set.of());
            List<StatementMatcher> statementMatchers = this.queryFragment.getStatementMatchers();
            if (statementMatchers.isEmpty()) {
                this.rootStatementMatcher = null;
            } else {
                this.rootStatementMatcher = this.queryFragment.getStatementMatchers().get(0);
                assert (this.rootStatementMatcher.getSubjectName() == var.getName() || this.rootStatementMatcher.getObjectName() == var.getName() || this.rootStatementMatcher.getSubjectName() == prev.var.getName() || this.rootStatementMatcher.getObjectName() == prev.var.getName());
            }
        }

        public SparqlFragment getQueryFragment() {
            return this.queryFragment;
        }

        public Stream<StatementsAndMatcher> getRoot(ConnectionsGroup connectionsGroup, Resource[] dataGraph, StatementMatcher currentStatementMatcher, Statement currentStatement) {
            if (currentStatementMatcher == this.rootStatementMatcher) {
                return null;
            }
            assert (this.prev != null);
            if (this.target instanceof SimplePath) {
                assert (currentStatementMatcher.hasSubset(this.rootStatementMatcher) || this.prev.var.getName().equals(currentStatementMatcher.getSubjectName()) || this.prev.var.getName().equals(currentStatementMatcher.getObjectName()));
                return null;
            }
            if (currentStatementMatcher.hasSubset(this.rootStatementMatcher)) {
                return null;
            }
            if (this.prev.var.getName().equals(currentStatementMatcher.getSubjectName()) || this.prev.var.getName().equals(currentStatementMatcher.getObjectName())) {
                return null;
            }
            assert (!currentStatementMatcher.covers(this.rootStatementMatcher));
            if (this.target instanceof Path) {
                Path path = (Path)this.target;
                assert (!(path instanceof InversePath));
                return this.queryFragment.getRoot(connectionsGroup, dataGraph, path, currentStatementMatcher, List.of(currentStatement));
            }
            throw new UnsupportedOperationException();
        }
    }

    public static enum Extend {
        left,
        right;

    }
}

