/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.lang;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.HashSet;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;

public final class GraphObject {
    private GraphObject() {
    }

    public static boolean isGraphObject(JsonValue value) {
        if (!JsonUtils.isObject(value) || !value.asJsonObject().containsKey((Object)"@graph")) {
            return false;
        }
        HashSet<String> allowed = new HashSet<String>(Arrays.asList("@graph", "@id", "@index", "@context"));
        return allowed.containsAll(value.asJsonObject().keySet());
    }

    public static boolean isSimpleGraphObject(JsonValue value) {
        return GraphObject.isGraphObject(value) && !value.asJsonObject().containsKey((Object)"@id");
    }

    public static JsonObject toGraphObject(JsonValue value) {
        return JsonProvider.instance().createObjectBuilder().add("@graph", (JsonValue)JsonUtils.toJsonArray(value)).build();
    }
}

