/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.lang.service;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceRegistry<K, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<K, S> services = new ConcurrentHashMap<K, S>(16, 0.75f, 1);

    protected ServiceRegistry(Class<S> serviceClass) {
        ServiceLoader<S> loader = ServiceLoader.load(serviceClass, serviceClass.getClassLoader());
        Iterator<S> services = loader.iterator();
        while (true) {
            try {
                while (services.hasNext()) {
                    S service = services.next();
                    Optional<S> oldService = this.add(service);
                    if (oldService.isPresent()) {
                        this.logger.warn("New service {} replaces existing service {}", service.getClass(), oldService.get().getClass());
                    }
                    this.logger.debug("Registered service class {}", (Object)service.getClass().getName());
                }
            }
            catch (Error e) {
                this.logger.error("Failed to instantiate service", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public Optional<S> add(S service) {
        return Optional.ofNullable(this.services.put(this.getKey(service), service));
    }

    public void remove(S service) {
        this.services.remove(this.getKey(service));
    }

    public Optional<S> get(K key) {
        return Optional.ofNullable(this.services.get(key));
    }

    public boolean has(K key) {
        return this.services.containsKey(key);
    }

    public Collection<S> getAll() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.services.keySet());
    }

    protected abstract K getKey(S var1);
}

