/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;

public abstract class GroupSerializerObjectArray<A>
implements GroupSerializer<A> {
    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (Object o : (Object[])vals) {
            this.serialize(out, o);
        }
    }

    public Object[] valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        Object[] ret = new Object[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.deserialize(in, -1);
        }
        return ret;
    }

    @Override
    public A valueArrayGet(Object vals, int pos) {
        return (A)((Object[])vals)[pos];
    }

    @Override
    public int valueArraySize(Object vals) {
        return ((Object[])vals).length;
    }

    public Object[] valueArrayEmpty() {
        return new Object[0];
    }

    public Object[] valueArrayPut(Object vals, int pos, A newValue) {
        return DataIO.arrayPut((Object[])vals, pos, newValue);
    }

    public Object[] valueArrayUpdateVal(Object vals, int pos, A newValue) {
        Object[] vals2 = (Object[])vals;
        vals2 = (Object[])vals2.clone();
        vals2[pos] = newValue;
        return vals2;
    }

    public Object[] valueArrayFromArray(Object[] objects) {
        return objects;
    }

    public Object[] valueArrayCopyOfRange(Object vals, int from, int to) {
        return Arrays.copyOfRange((Object[])vals, from, to);
    }

    public Object[] valueArrayDeleteValue(Object vals, int pos) {
        return DataIO.arrayDelete((Object[])vals, pos, 1);
    }

    @Override
    public int valueArraySearch(Object keys, A key) {
        return Arrays.binarySearch((Object[])keys, key, this);
    }

    @Override
    public Object[] valueArrayToArray(Object vals) {
        return (Object[])vals;
    }

    @Override
    public int valueArraySearch(Object keys, A key, Comparator comparator) {
        if (comparator == this) {
            return this.valueArraySearch(keys, key);
        }
        return Arrays.binarySearch((Object[])keys, key, comparator);
    }
}

