/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.ValueStore;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

class LmdbStatementIterator
extends LookAheadIteration<Statement> {
    private final RecordIterator recordIt;
    private final ValueStore valueStore;

    public LmdbStatementIterator(RecordIterator recordIt, ValueStore valueStore) {
        this.recordIt = recordIt;
        this.valueStore = valueStore;
    }

    @Override
    public Statement getNextElement() throws SailException {
        try {
            long[] quad = this.recordIt.next();
            if (quad == null) {
                return null;
            }
            long subjID = quad[0];
            Resource subj = (Resource)((Object)this.valueStore.getLazyValue(subjID));
            long predID = quad[1];
            IRI pred = (IRI)((Object)this.valueStore.getLazyValue(predID));
            long objID = quad[2];
            LmdbValue obj = this.valueStore.getLazyValue(objID);
            Resource context = null;
            long contextID = quad[3];
            if (contextID != 0L) {
                context = (Resource)((Object)this.valueStore.getLazyValue(contextID));
            }
            return this.valueStore.createStatement(subj, pred, obj, context);
        }
        catch (IOException e) {
            throw this.causeIOException(e);
        }
    }

    @Override
    protected void handleClose() throws SailException {
        this.recordIt.close();
    }

    private SailException causeIOException(IOException e) {
        return new SailException(e);
    }
}

