/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageInFilter
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(LanguageInFilter.class);
    private final List<String> languageRanges;
    private final Set<String> lowerCaseLanguageIn;

    public LanguageInFilter(PlanNode parent, Set<String> lowerCaseLanguageIn, List<String> languageRanges, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.lowerCaseLanguageIn = lowerCaseLanguageIn;
        this.languageRanges = languageRanges;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        if (!t.get().getValue().isLiteral()) {
            logger.debug("Tuple rejected because it's not a literal. Tuple: {}", (Object)t);
            return false;
        }
        Optional<String> language = ((Literal)t.get().getValue()).getLanguage();
        if (language.isEmpty()) {
            logger.debug("Tuple rejected because it does not have a language tag. Tuple: {}", (Object)t);
            return false;
        }
        boolean languageMatches = language.map(String::toLowerCase).filter(this.lowerCaseLanguageIn::contains).isPresent();
        if (languageMatches) {
            logger.trace("Tuple accepted because its language tag (toLowerCase()) is in the language set. Actual language: {}, Language set: {}, Tuple: {}", new Object[]{language.get(), this.lowerCaseLanguageIn, t});
            return true;
        }
        String langTag = language.get();
        for (String languageRange : this.languageRanges) {
            if (!Literals.langMatches(langTag, languageRange)) continue;
            logger.trace("Tuple accepted because its language tag matches the language range (BCP47). Actual language: {}, Language range: {}, Tuple: {}", new Object[]{langTag, languageRange, t});
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "LanguageInFilter{languageRanges=" + Arrays.toString(this.languageRanges.toArray()) + ", lowerCaseLanguageIn=" + Arrays.toString(this.lowerCaseLanguageIn.toArray()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LanguageInFilter that = (LanguageInFilter)o;
        return this.languageRanges.equals(that.languageRanges) && this.lowerCaseLanguageIn.equals(that.lowerCaseLanguageIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.languageRanges, this.lowerCaseLanguageIn);
    }
}

