/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockTracking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveReentrantLockManager {
    private static final Logger logger = LoggerFactory.getLogger(ExclusiveReentrantLockManager.class);
    final AtomicLong activeLocks = new AtomicLong();
    final AtomicReference<Thread> owner = new AtomicReference();
    private final int waitToCollect;
    LockMonitoring<ExclusiveReentrantLock> lockMonitoring;

    public ExclusiveReentrantLockManager() {
        this(false);
    }

    public ExclusiveReentrantLockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public ExclusiveReentrantLockManager(boolean trackLocks, int collectionFrequency) {
        this.waitToCollect = collectionFrequency;
        this.lockMonitoring = trackLocks || Properties.lockTrackingEnabled() ? new LockTracking<Lock>(true, "ExclusiveReentrantLockManager", LoggerFactory.getLogger(this.getClass()), this.waitToCollect, Lock.ExtendedSupplier.wrap(this::getExclusiveLockInner, this::tryExclusiveLockInner)) : new LockCleaner<Lock>(false, "ExclusiveReentrantLockManager", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::getExclusiveLockInner, this::tryExclusiveLockInner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock tryExclusiveLockInner() {
        AtomicReference<Thread> atomicReference = this.owner;
        synchronized (atomicReference) {
            if (this.owner.get() == Thread.currentThread()) {
                this.activeLocks.incrementAndGet();
                return new ExclusiveReentrantLock(this.owner, this.activeLocks);
            }
            if (this.owner.compareAndSet(null, Thread.currentThread())) {
                this.activeLocks.incrementAndGet();
                return new ExclusiveReentrantLock(this.owner, this.activeLocks);
            }
        }
        return null;
    }

    private Lock getExclusiveLockInner() throws InterruptedException {
        AtomicReference<Thread> atomicReference = this.owner;
        synchronized (atomicReference) {
            if (this.lockMonitoring.requiresManualCleanup()) {
                while (true) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Lock lock = this.tryExclusiveLockInner();
                    if (lock != null) {
                        return lock;
                    }
                    this.lockMonitoring.runCleanup();
                    this.owner.wait(this.waitToCollect);
                }
            }
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Lock lock = this.tryExclusiveLockInner();
                if (lock != null) {
                    return lock;
                }
                this.owner.wait(this.waitToCollect);
            }
        }
    }

    public Lock tryExclusiveLock() {
        return this.lockMonitoring.tryLock();
    }

    public Lock getExclusiveLock() throws InterruptedException {
        return this.lockMonitoring.getLock();
    }

    public boolean isActiveLock() {
        return this.owner.get() != null;
    }

    static class ExclusiveReentrantLock
    implements Lock {
        final AtomicLong activeLocks;
        final AtomicReference<Thread> owner;
        private boolean released = false;

        public ExclusiveReentrantLock(AtomicReference<Thread> owner, AtomicLong activeLocks) {
            this.owner = owner;
            this.activeLocks = activeLocks;
        }

        @Override
        public boolean isActive() {
            return !this.released;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            if (this.released) {
                throw new IllegalStateException("Lock already released");
            }
            AtomicReference<Thread> atomicReference = this.owner;
            synchronized (atomicReference) {
                if (this.owner.get() != Thread.currentThread()) {
                    logger.warn("Releasing lock from different thread, owner: " + this.owner.get() + ", current: " + Thread.currentThread());
                }
                if (this.activeLocks.decrementAndGet() == 0L) {
                    this.owner.set(null);
                    this.owner.notifyAll();
                }
            }
            this.released = true;
        }
    }
}

