/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.binary;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.AbstractTupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.binary.BinaryQueryResultConstants;
import org.eclipse.rdf4j.query.resultio.binary.QueryErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryQueryResultParser
extends AbstractTupleQueryResultParser {
    private DataInputStream in;
    private int formatVersion;
    private final CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder();
    private static final Logger logger = LoggerFactory.getLogger(BinaryQueryResultParser.class);
    private String[] namespaceArray = new String[32];
    private static final int INVALID_CONTENT_LIMIT = 8192;

    public BinaryQueryResultParser() {
    }

    public BinaryQueryResultParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.BINARY;
    }

    @Override
    public synchronized void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        int columnCount;
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        this.in = new DataInputStream(in);
        byte[] magicNumber = IOUtil.readBytes(in, BinaryQueryResultConstants.MAGIC_NUMBER.length);
        if (!Arrays.equals(magicNumber, BinaryQueryResultConstants.MAGIC_NUMBER)) {
            throw new QueryResultParseException("File does not contain a binary RDF table result");
        }
        this.formatVersion = this.in.readInt();
        if (this.formatVersion > 4 && this.formatVersion < 1) {
            throw new QueryResultParseException("Incompatible format version: " + this.formatVersion);
        }
        if (this.formatVersion == 2) {
            this.in.readByte();
        }
        if ((columnCount = this.in.readInt()) < 0) {
            throw new QueryResultParseException("Illegal column count specified: " + columnCount);
        }
        ArrayList<String> columnHeaders = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnHeaders.add(this.readString());
        }
        columnHeaders = Collections.unmodifiableList(columnHeaders);
        if (this.handler != null) {
            this.handler.startQueryResult(columnHeaders);
        }
        ArrayList<IRI> currentTuple = new ArrayList<IRI>(columnCount);
        List<Value> previousTuple = Collections.nCopies(columnCount, null);
        byte recordTypeMarker = this.in.readByte();
        while (recordTypeMarker != 127) {
            if (recordTypeMarker == 126) {
                this.processError();
            } else if (recordTypeMarker == 2) {
                this.processNamespace();
            } else if (recordTypeMarker == 9) {
                if (this.handler != null) {
                    this.handler.handleSolution(EmptyBindingSet.getInstance());
                }
            } else {
                Value value = null;
                switch (recordTypeMarker) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        value = previousTuple.get(currentTuple.size());
                        break;
                    }
                    case 3: {
                        value = this.readQName();
                        break;
                    }
                    case 4: {
                        value = this.readURI();
                        break;
                    }
                    case 5: {
                        value = this.readBnode();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        value = this.readLiteral(recordTypeMarker);
                        break;
                    }
                    case 10: {
                        value = this.readTriple();
                        break;
                    }
                    default: {
                        logger.error(this.extractInvalidContentAsString(recordTypeMarker));
                        throw new QueryResultParseException("Could not parse the query result.");
                    }
                }
                currentTuple.add((IRI)value);
                if (currentTuple.size() == columnCount) {
                    previousTuple = Collections.unmodifiableList(currentTuple);
                    currentTuple = new ArrayList(columnCount);
                    if (this.handler != null) {
                        this.handler.handleSolution(new ListBindingSet(columnHeaders, previousTuple));
                    }
                }
            }
            recordTypeMarker = this.in.readByte();
        }
        if (this.handler != null) {
            this.handler.endQueryResult();
        }
    }

    private void processError() throws IOException, QueryResultParseException {
        QueryErrorType errType;
        byte errTypeFlag = this.in.readByte();
        if (errTypeFlag == 1) {
            errType = QueryErrorType.MALFORMED_QUERY_ERROR;
        } else if (errTypeFlag == 2) {
            errType = QueryErrorType.QUERY_EVALUATION_ERROR;
        } else {
            throw new QueryResultParseException("Unknown error type: " + errTypeFlag);
        }
        String msg = this.readString();
        throw new QueryResultParseException(errType + ": " + msg);
    }

    private void processNamespace() throws IOException {
        int namespaceID = this.in.readInt();
        String namespace = this.readString();
        if (namespaceID >= this.namespaceArray.length) {
            int newSize = Math.max(namespaceID, this.namespaceArray.length * 2);
            String[] newArray = new String[newSize];
            System.arraycopy(this.namespaceArray, 0, newArray, 0, this.namespaceArray.length);
            this.namespaceArray = newArray;
        }
        this.namespaceArray[namespaceID] = namespace;
    }

    private IRI readQName() throws IOException {
        int nsID = this.in.readInt();
        String localName = this.readString();
        return this.valueFactory.createIRI(this.namespaceArray[nsID], localName);
    }

    private IRI readURI() throws IOException {
        String uri = this.readString();
        return this.valueFactory.createIRI(uri);
    }

    private BNode readBnode() throws IOException {
        String bnodeID = this.readString();
        return this.valueFactory.createBNode(bnodeID);
    }

    private Literal readLiteral(int recordTypeMarker) throws IOException, QueryResultParseException {
        String label = this.readString();
        if (recordTypeMarker == 8) {
            IRI datatype;
            byte dtTypeMarker = this.in.readByte();
            switch (dtTypeMarker) {
                case 3: {
                    datatype = this.readQName();
                    break;
                }
                case 4: {
                    datatype = this.readURI();
                    break;
                }
                default: {
                    throw new QueryResultParseException("Illegal record type marker for literal's datatype");
                }
            }
            return this.valueFactory.createLiteral(label, datatype);
        }
        if (recordTypeMarker == 7) {
            String language = this.readString();
            return this.valueFactory.createLiteral(label, language);
        }
        return this.valueFactory.createLiteral(label);
    }

    private String readString() throws IOException {
        if (this.formatVersion == 1) {
            return this.readStringV1();
        }
        return this.readStringV2();
    }

    private String extractInvalidContentAsString(int recordTypeMarker) throws IOException {
        String remainingSymbols;
        byte[] remainingBytes = new byte[8192];
        IOUtil.readBytes((InputStream)this.in, remainingBytes);
        ByteBuffer byteBuf = ByteBuffer.wrap(remainingBytes);
        CharBuffer charBuf = this.charsetDecoder.decode(byteBuf);
        String result = remainingSymbols = charBuf.toString();
        if (remainingSymbols.contains("Exception")) {
            result = remainingSymbols.substring(0, remainingSymbols.lastIndexOf(41) + 1);
        }
        return Character.toString(recordTypeMarker) + result + "...";
    }

    private String readStringV1() throws IOException {
        return this.in.readUTF();
    }

    private String readStringV2() throws IOException {
        int stringLength = this.in.readInt();
        byte[] encodedString = IOUtil.readBytes((InputStream)this.in, stringLength);
        if (encodedString.length != stringLength) {
            throw new EOFException("Attempted to read " + stringLength + " bytes but no more than " + encodedString.length + " were available");
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(encodedString);
        CharBuffer charBuf = this.charsetDecoder.decode(byteBuf);
        return charBuf.toString();
    }

    private Triple readTriple() throws IOException {
        Value subject = this.readDirectValue();
        if (!(subject instanceof Resource)) {
            throw new IOException("Unexpected value type: " + subject);
        }
        Value predicate = this.readDirectValue();
        if (!(predicate instanceof IRI)) {
            throw new IOException("Unexpected value type: " + predicate);
        }
        Value object = this.readDirectValue();
        return this.valueFactory.createTriple((Resource)subject, (IRI)predicate, object);
    }

    private Value readDirectValue() throws IOException {
        byte recordTypeMarker = this.in.readByte();
        switch (recordTypeMarker) {
            case 2: {
                this.processNamespace();
                return this.readDirectValue();
            }
            case 3: {
                return this.readQName();
            }
            case 4: {
                return this.readURI();
            }
            case 5: {
                return this.readBnode();
            }
            case 6: 
            case 7: 
            case 8: {
                return this.readLiteral(recordTypeMarker);
            }
            case 10: {
                return this.readTriple();
            }
        }
        throw new IOException("Unexpected record type: " + recordTypeMarker);
    }
}

