/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnectionWrapper;
import org.eclipse.rdf4j.sail.model.SailModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardChainingInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractForwardChainingInferencerConnection.class);
    private final Sail sail;
    private boolean statementsRemoved;
    private Model newStatements;
    protected int totalInferred;

    public AbstractForwardChainingInferencerConnection(Sail sail, InferencerConnection con) {
        super(con);
        this.sail = sail;
        con.addConnectionListener(this);
    }

    @Override
    public void statementAdded(Statement st) {
        if (this.statementsRemoved) {
            return;
        }
        if (this.newStatements == null) {
            this.newStatements = this.createModel();
        }
        this.newStatements.add(st);
    }

    protected abstract Model createModel();

    @Override
    public void statementRemoved(Statement st) {
        boolean removed;
        boolean bl = removed = this.newStatements != null ? this.newStatements.remove(st) : false;
        if (!removed) {
            this.statementsRemoved = true;
            this.newStatements = null;
        }
    }

    @Override
    public void flushUpdates() throws SailException {
        if (this.needsFullRecomputation()) {
            logger.debug("full recomputation needed, starting inferencing from scratch");
            this.clearInferred(new Resource[0]);
            super.flushUpdates();
            this.addAxiomStatements();
            super.flushUpdates();
            this.newStatements = new SailModel(this.getWrappedConnection(), true);
            this.statementsRemoved = false;
        } else {
            super.flushUpdates();
        }
        if (this.hasNewStatements()) {
            this.doInferencing();
        }
        this.newStatements = null;
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    @Override
    public void begin(IsolationLevel level) throws SailException {
        IsolationLevel compatibleLevel = IsolationLevels.getCompatibleIsolationLevel(level, this.sail.getSupportedIsolationLevels());
        if (compatibleLevel == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + String.valueOf(level) + " not compatible with this Sail");
        }
        super.begin(compatibleLevel);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        this.statementsRemoved = false;
        this.newStatements = null;
    }

    protected abstract void addAxiomStatements() throws SailException;

    protected void doInferencing() throws SailException {
        this.totalInferred = 0;
        int iteration = 0;
        while (this.hasNewStatements()) {
            logger.trace("starting iteration " + ++iteration);
            Model newThisIteration = this.prepareIteration();
            int nofInferred = this.applyRules(newThisIteration);
            logger.trace("iteration " + iteration + " done; inferred " + nofInferred + " new statements");
            this.totalInferred += nofInferred;
        }
        if (this.totalInferred > 0) {
            logger.debug("{} inferred {} new statements", (Object)this.getClass().getName(), (Object)this.totalInferred);
        }
    }

    protected abstract int applyRules(Model var1) throws SailException;

    protected Model prepareIteration() {
        Model newThisIteration = this.newStatements;
        this.newStatements = null;
        return newThisIteration;
    }

    protected boolean hasNewStatements() {
        return this.newStatements != null;
    }

    protected boolean needsFullRecomputation() {
        return this.statementsRemoved;
    }
}

