/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gwtorm.client.Column;

public final class AccountGeneralPreferences {
    public static final short DEFAULT_PAGESIZE = 25;
    public static final short[] PAGESIZE_CHOICES = new short[]{10, 25, 50, 100};
    @Column(id=2)
    protected short maximumPageSize;
    @Column(id=3)
    protected boolean showSiteHeader;
    @Column(id=4)
    protected boolean useFlashClipboard;
    @Column(id=5, length=20, notNull=false)
    protected String downloadUrl;
    @Column(id=6, length=20, notNull=false)
    protected String downloadCommand;
    @Column(id=7)
    protected boolean copySelfOnEmail;

    public short getMaximumPageSize() {
        return this.maximumPageSize;
    }

    public void setMaximumPageSize(short s) {
        this.maximumPageSize = s;
    }

    public boolean isShowSiteHeader() {
        return this.showSiteHeader;
    }

    public void setShowSiteHeader(boolean b) {
        this.showSiteHeader = b;
    }

    public boolean isUseFlashClipboard() {
        return this.useFlashClipboard;
    }

    public void setUseFlashClipboard(boolean b) {
        this.useFlashClipboard = b;
    }

    public DownloadScheme getDownloadUrl() {
        if (this.downloadUrl == null) {
            return null;
        }
        return DownloadScheme.valueOf(this.downloadUrl);
    }

    public void setDownloadUrl(DownloadScheme url) {
        this.downloadUrl = url != null ? url.name() : null;
    }

    public DownloadCommand getDownloadCommand() {
        if (this.downloadCommand == null) {
            return null;
        }
        return DownloadCommand.valueOf(this.downloadCommand);
    }

    public void setDownloadCommand(DownloadCommand cmd) {
        this.downloadCommand = cmd != null ? cmd.name() : null;
    }

    public boolean isCopySelfOnEmails() {
        return this.copySelfOnEmail;
    }

    public void setCopySelfOnEmails(boolean includeSelfOnEmail) {
        this.copySelfOnEmail = includeSelfOnEmail;
    }

    public void resetToDefaults() {
        this.maximumPageSize = (short)25;
        this.showSiteHeader = true;
        this.useFlashClipboard = true;
        this.copySelfOnEmail = false;
        this.downloadUrl = null;
        this.downloadCommand = null;
    }

    public static enum DownloadCommand {
        REPO_DOWNLOAD,
        PULL,
        CHECKOUT,
        CHERRY_PICK,
        FORMAT_PATCH;

    }

    public static enum DownloadScheme {
        ANON_GIT,
        ANON_HTTP,
        ANON_SSH,
        HTTP,
        SSH,
        REPO_DOWNLOAD,
        DEFAULT_DOWNLOADS;

    }
}

