/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.SelectionUtils;
import net.sourceforge.nattable.selection.command.SelectColumnCommand;
import net.sourceforge.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectColumnCommandHandler
implements ILayerCommandHandler<SelectColumnCommand> {
    private final SelectionLayer selectionLayer;

    public SelectColumnCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SelectColumnCommand command) {
        if (command.convertToTargetLayer(this.selectionLayer)) {
            this.selectColumn(command.getColumnPosition(), command.getRowPosition(), command.isWithShiftMask(), command.isWithControlMask());
            return true;
        }
        return false;
    }

    protected void selectColumn(int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        if (SelectionUtils.noShiftOrControl(withShiftMask, withControlMask)) {
            this.selectionLayer.clear();
            this.selectionLayer.selectCell(columnPosition, 0, false, false);
            this.selectionLayer.selectRegion(columnPosition, 0, 1, this.selectionLayer.getRowCount());
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        } else if (SelectionUtils.bothShiftAndControl(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isShiftOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithShiftKey(columnPosition);
        } else if (SelectionUtils.isControlOnly(withShiftMask, withControlMask)) {
            this.selectColumnWithCtrlKey(columnPosition, rowPosition);
        }
        this.selectionLayer.lastSelectedCell.columnPosition = columnPosition;
        this.selectionLayer.lastSelectedCell.rowPosition = this.selectionLayer.getRowCount() - 1;
        this.selectionLayer.fireLayerEvent(new ColumnSelectionEvent(this.selectionLayer, columnPosition));
    }

    private void selectColumnWithCtrlKey(int columnPosition, int rowPosition) {
        Rectangle selectedColumnRectangle = new Rectangle(columnPosition, 0, 1, this.selectionLayer.getRowCount());
        if (this.selectionLayer.isColumnFullySelected(columnPosition)) {
            this.selectionLayer.clearSelection(selectedColumnRectangle);
            if (this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.lastSelectedRegion.equals((Object)selectedColumnRectangle)) {
                this.selectionLayer.lastSelectedRegion = null;
            }
        } else {
            if (this.selectionLayer.lastSelectedRegion != null) {
                this.selectionLayer.selectionModel.addSelection(new Rectangle(this.selectionLayer.lastSelectedRegion.x, this.selectionLayer.lastSelectedRegion.y, this.selectionLayer.lastSelectedRegion.width, this.selectionLayer.lastSelectedRegion.height));
            }
            this.selectionLayer.selectRegion(columnPosition, 0, 1, this.selectionLayer.getRowCount());
            this.selectionLayer.moveSelectionAnchor(columnPosition, rowPosition);
        }
    }

    private void selectColumnWithShiftKey(int columnPosition) {
        int numOfColumnsToIncludeInRegion = 1;
        int startColumnPosition = columnPosition;
        if (this.selectionLayer.lastSelectedRegion != null) {
            numOfColumnsToIncludeInRegion = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - columnPosition) + 1;
            startColumnPosition = columnPosition < this.selectionLayer.selectionAnchor.columnPosition ? columnPosition : this.selectionLayer.selectionAnchor.columnPosition;
        }
        this.selectionLayer.selectRegion(startColumnPosition, 0, numOfColumnsToIncludeInRegion, this.selectionLayer.getRowCount());
    }

    @Override
    public Class<SelectColumnCommand> getCommandClass() {
        return SelectColumnCommand.class;
    }
}

