/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.AbstractClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;

public class ClasspathModel
extends AbstractClasspathEntry {
    public static final int ANT_HOME = 0;
    public static final int GLOBAL_USER = 1;
    public static final int USER = 2;
    public static final int CONTRIBUTED = 3;
    private GlobalClasspathEntries fAntHomeEntry;
    private GlobalClasspathEntries fUserGlobalEntry;
    private GlobalClasspathEntries fContributedGlobalEntry;

    public Object addEntry(Object entry) {
        if (entry instanceof GlobalClasspathEntries) {
            if (!this.fChildEntries.contains(entry)) {
                this.fChildEntries.add((IAntClasspathEntry)entry);
                return entry;
            }
            return null;
        }
        ClasspathEntry newEntry = this.createEntry(entry, null);
        for (IAntClasspathEntry element : this.fChildEntries) {
            if (!(element instanceof GlobalClasspathEntries ? ((GlobalClasspathEntries)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        this.fChildEntries.add(newEntry);
        return newEntry;
    }

    public Object addEntry(int entryType, Object entry) {
        GlobalClasspathEntries entryParent = null;
        switch (entryType) {
            case 0: {
                String name;
                if (this.fAntHomeEntry == null) {
                    name = AntPreferencesMessages.ClasspathModel_2;
                    this.fAntHomeEntry = this.createGlobalEntry(new IAntClasspathEntry[0], name, false, true, 0);
                }
                entryParent = this.fAntHomeEntry;
                break;
            }
            case 1: {
                String name;
                if (this.fUserGlobalEntry == null) {
                    name = AntPreferencesMessages.ClasspathModel_3;
                    this.fUserGlobalEntry = this.createGlobalEntry(new IAntClasspathEntry[0], name, true, true, 1);
                }
                entryParent = this.fUserGlobalEntry;
                break;
            }
            case 3: {
                String name;
                if (this.fContributedGlobalEntry == null) {
                    name = AntPreferencesMessages.ClasspathModel_0;
                    this.fContributedGlobalEntry = this.createGlobalEntry(new IAntClasspathEntry[0], name, true, true, 3);
                }
                entryParent = this.fContributedGlobalEntry;
                break;
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        for (IAntClasspathEntry element : this.fChildEntries) {
            if (!(element instanceof GlobalClasspathEntries ? ((GlobalClasspathEntries)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            entryParent.addEntry(newEntry);
        } else {
            this.fChildEntries.add(newEntry);
        }
        return newEntry;
    }

    public IAntClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.fAntHomeEntry == null) break;
                return this.fAntHomeEntry.getEntries();
            }
            case 1: {
                if (this.fUserGlobalEntry == null) break;
                return this.fUserGlobalEntry.getEntries();
            }
            case 2: {
                return this.getUserEntries();
            }
            case 3: {
                if (this.fContributedGlobalEntry == null) break;
                return this.fContributedGlobalEntry.getEntries();
            }
        }
        return new IAntClasspathEntry[0];
    }

    public void remove(Object entry) {
        this.fChildEntries.remove(entry);
        if (entry == this.fUserGlobalEntry) {
            this.fUserGlobalEntry = null;
        }
    }

    public ClasspathEntry createEntry(Object entry, IClasspathEntry entryParent) {
        if (entryParent == null) {
            entryParent = this;
        }
        return new ClasspathEntry(entry, entryParent);
    }

    public void removeAll() {
        if (this.fAntHomeEntry != null) {
            this.fAntHomeEntry.removeAll();
        }
        if (this.fUserGlobalEntry != null) {
            this.fUserGlobalEntry.removeAll();
        }
    }

    public void removeAll(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.fAntHomeEntry == null) break;
                this.fAntHomeEntry.removeAll();
                break;
            }
            case 1: {
                if (this.fUserGlobalEntry == null) break;
                this.fUserGlobalEntry.removeAll();
                break;
            }
        }
    }

    public void removeAll(Object[] entries) {
        int i = 0;
        while (i < entries.length) {
            Object object = entries[i];
            if (object instanceof ClasspathEntry) {
                IClasspathEntry entryParent = ((ClasspathEntry)object).getParent();
                if (entryParent instanceof GlobalClasspathEntries) {
                    ((GlobalClasspathEntries)entryParent).removeEntry((ClasspathEntry)object);
                } else {
                    this.remove(object);
                }
            } else {
                this.remove(object);
            }
            ++i;
        }
    }

    public void setAntHomeEntries(IAntClasspathEntry[] entries) {
        if (this.fAntHomeEntry == null) {
            String name = AntPreferencesMessages.ClasspathModel_2;
            this.fAntHomeEntry = this.createGlobalEntry(entries, name, false, true, 0);
        } else {
            this.fAntHomeEntry.removeAll();
            int i = 0;
            while (i < entries.length) {
                this.fAntHomeEntry.addEntry(new ClasspathEntry(entries[i], this.fAntHomeEntry));
                ++i;
            }
        }
    }

    private GlobalClasspathEntries createGlobalEntry(IAntClasspathEntry[] entries, String name, boolean canBeRemoved, boolean addEntry, int type) {
        GlobalClasspathEntries global = new GlobalClasspathEntries(name, this, canBeRemoved, type);
        int i = 0;
        while (i < entries.length) {
            global.addEntry(new ClasspathEntry(entries[i], global));
            ++i;
        }
        if (addEntry) {
            this.addEntry(global);
        }
        return global;
    }

    public void setGlobalEntries(IAntClasspathEntry[] entries) {
        if (this.fUserGlobalEntry == null) {
            String name = AntPreferencesMessages.ClasspathModel_3;
            this.fUserGlobalEntry = this.createGlobalEntry(entries, name, true, true, 1);
        } else {
            this.fUserGlobalEntry.removeAll();
            int i = 0;
            while (i < entries.length) {
                this.fUserGlobalEntry.addEntry(new ClasspathEntry(entries[i], this.fUserGlobalEntry));
                ++i;
            }
        }
    }

    public void setContributedEntries(IAntClasspathEntry[] entries) {
        if (this.fContributedGlobalEntry == null) {
            String name = AntPreferencesMessages.ClasspathModel_0;
            this.fContributedGlobalEntry = this.createGlobalEntry(entries, name, false, true, 3);
        } else {
            this.fContributedGlobalEntry.removeAll();
            int i = 0;
            while (i < entries.length) {
                this.fContributedGlobalEntry.addEntry(new ClasspathEntry(entries[i], this.fContributedGlobalEntry));
                ++i;
            }
        }
    }

    private IAntClasspathEntry[] getUserEntries() {
        ArrayList<IAntClasspathEntry> userEntries = new ArrayList<IAntClasspathEntry>(this.fChildEntries.size());
        for (IAntClasspathEntry element : this.fChildEntries) {
            if (element instanceof GlobalClasspathEntries) continue;
            userEntries.add(element);
        }
        return userEntries.toArray(new IAntClasspathEntry[userEntries.size()]);
    }
}

