/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.data.api.cube.TimeDimensionUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.DimensionRowAccessor;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public interface IJSObjectPopulator {
    public void doInit() throws DataException;

    public void setData(Object var1);

    public void cleanUp();

    public static class DummyJSAggregationAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = -7910516821739958908L;
        private IResultRow resultRow;
        private Scriptable outResultsScriptable;
        private List bindings;
        private Scriptable scope;
        private ScriptContext cx;

        public DummyJSAggregationAccessor(IBaseQueryResults outResults, Scriptable scope, ScriptContext cx, List bindings) throws DataException {
            this.outResultsScriptable = OlapExpressionUtil.createQueryResultsScriptable(outResults);
            this.bindings = bindings;
            this.scope = scope;
            this.cx = cx;
        }

        private static boolean isAggregationBinding(String bindingName, List bindings) throws DataException {
            boolean find = false;
            int i = 0;
            while (i < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(i);
                if (bindingName.equals(binding.getBindingName())) {
                    find = true;
                    if (OlapExpressionUtil.isAggregationBinding(binding)) {
                        return true;
                    }
                    if (OlapExpressionUtil.isDirectRerenrence(binding.getExpression(), bindings)) {
                        return false;
                    }
                    List<String> refBindingName = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
                    int j = 0;
                    while (j < refBindingName.size()) {
                        if (DummyJSAggregationAccessor.isAggregationBinding(refBindingName.get(j), bindings)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return !find;
        }

        private static IBinding getBinding(String bindingName, List bindings) throws DataException {
            int j = 0;
            while (j < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(j);
                if (bindingName.equals(binding.getBindingName())) {
                    return binding;
                }
                ++j;
            }
            return null;
        }

        public Object get(String aggrName, Scriptable scope) {
            if (aggrName.equals("_outer")) {
                if (this.outResultsScriptable == null) {
                    throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                }
                return this.outResultsScriptable;
            }
            if (this.resultRow != null) {
                try {
                    if (DummyJSAggregationAccessor.isAggregationBinding(aggrName, this.bindings)) {
                        return this.resultRow.getAggrValue(aggrName);
                    }
                    IBinding binding = DummyJSAggregationAccessor.getBinding(aggrName, this.bindings);
                    Object result = ScriptEvalUtil.evalExpr(binding.getExpression(), this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                    if (result instanceof Scriptable) {
                        return ((Scriptable)result).getDefaultValue(null);
                    }
                    result = DataTypeUtil.convert((Object)result, (int)binding.getDataType());
                    return result;
                }
                catch (DataException e) {
                    return e;
                }
                catch (BirtException e) {
                    return e;
                }
            }
            return null;
        }

        public void setResultRow(IResultRow row) {
            this.resultRow = row;
        }

        public String getClassName() {
            return "DummyJSAggregationAccessor";
        }
    }

    public static class DummyJSDataAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 1151785733090446202L;
        private Map bindingMap = new HashMap();
        private Scriptable scope;
        private Scriptable outResultsScriptable;
        private ScriptContext cx;
        private DummyJSAggregationAccessor aggrAccessor;

        public DummyJSDataAccessor(IBaseQueryResults outResults, List bindings, Scriptable scope, ScriptContext cx, DummyJSAggregationAccessor aggrAccessor) throws DataException {
            this.cx = cx;
            int i = 0;
            while (i < bindings.size()) {
                this.bindingMap.put(((IBinding)bindings.get(i)).getBindingName(), bindings.get(i));
                ++i;
            }
            this.scope = scope;
            this.aggrAccessor = aggrAccessor;
            if (outResults != null) {
                if (outResults instanceof ICubeQueryResults) {
                    this.outResultsScriptable = new JSCubeBindingObject(((ICubeQueryResults)outResults).getCubeCursor());
                } else if (outResults instanceof IQueryResults) {
                    try {
                        this.outResultsScriptable = OlapExpressionUtil.createQueryResultsScriptable(outResults);
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(String aggrName, Scriptable scope) {
            try {
                if (aggrName.equals("_outer")) {
                    if (this.outResultsScriptable == null) {
                        throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                    }
                    return this.outResultsScriptable;
                }
                Object o = this.aggrAccessor.get(aggrName, scope);
                if (o != null) {
                    if (o instanceof DataException) {
                        return null;
                    }
                    return o;
                }
                if (!this.bindingMap.containsKey(aggrName)) {
                    return null;
                }
                Object result = ScriptEvalUtil.evalExpr(((IBinding)this.bindingMap.get(aggrName)).getExpression(), this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                if (result instanceof Scriptable) {
                    return ((Scriptable)result).getDefaultValue(null);
                }
                return result;
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public String getClassName() {
            return null;
        }
    }

    public static class DummyJSDimensionAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 6340543910367862168L;
        private String dimensionName;
        private DummyJSDimensionObject dimObj;

        public DummyJSDimensionAccessor(String name, DummyJSDimensionObject dimObj) {
            assert (name != null);
            assert (dimObj != null);
            this.dimensionName = name;
            this.dimObj = dimObj;
        }

        public String getClassName() {
            return "DummyJSDimensionAccessor";
        }

        public Object get(String value, Scriptable scope) {
            if (!this.dimensionName.equals(value)) {
                throw new InMatchDimensionIndicator();
            }
            return this.dimObj;
        }
    }

    public static class DummyJSDimensionObject
    extends ScriptableObject {
        private static final long serialVersionUID = -5318363452556444748L;
        private DummyJSLevels levels;
        private List levelNames;
        private boolean useDimensionLevel;

        public DummyJSDimensionObject(DummyJSLevels levels, List levelNames) {
            this.levels = levels;
            this.levelNames = levelNames;
            this.useDimensionLevel = false;
        }

        public String getClassName() {
            return "DummyJSDimensionObject";
        }

        public Object get(String value, Scriptable scope) {
            if (this.levels.isTimeDimLevel() && TimeDimensionUtil.getFieldIndex(value) == -1) {
                throw new RuntimeException("Invalid level Name:" + value);
            }
            if (!this.useDimensionLevel && this.levels.getLevelNames() != null) {
                this.levelNames = this.levels.getLevelNames();
                this.useDimensionLevel = true;
            }
            if (this.levelNames.contains(value)) {
                this.levels.setCurrentKey(value);
                return this.levels;
            }
            throw new RuntimeException("Invalid level Name:" + value);
        }
    }

    public static class DummyJSFacttableMeasureAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = -7910516821739958908L;
        private IFacttableRow resultRow;
        private Map computedMeasures;
        private Scriptable scope;
        private ScriptContext cx;

        public DummyJSFacttableMeasureAccessor(Map computedMeasures, Scriptable scope, ScriptContext cx) {
            this.computedMeasures = computedMeasures;
            this.scope = scope;
            this.cx = cx;
        }

        public Object get(String aggrName, Scriptable scope) {
            if (this.resultRow != null) {
                block6: {
                    try {
                        if (!this.computedMeasures.containsKey(aggrName)) break block6;
                        try {
                            return ScriptEvalUtil.evalExpr((IBaseExpression)this.computedMeasures.get(aggrName), this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    catch (DataException dataException) {
                        return null;
                    }
                }
                return this.resultRow.getMeasureValue(aggrName);
            }
            return null;
        }

        public void setResultRow(IFacttableRow row) {
            this.resultRow = row;
        }

        public String getClassName() {
            return "DummyJSFacttableMeasureAccessor";
        }
    }

    public static class DummyJSLevels
    extends ScriptableObject {
        private static final long serialVersionUID = 2025085361323969740L;
        private IResultRow resultRow;
        private String key;
        private String dimName;

        public DummyJSLevels(String dimName) {
            this.dimName = dimName;
        }

        public String getClassName() {
            return "DummyJSLevels";
        }

        public Object getDefaultValue(Class hint) {
            try {
                if (this.resultRow.isTimeDimensionRow()) {
                    return this.resultRow.getFieldValue(this.key);
                }
                return this.resultRow.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.key, this.key));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public Object get(String value, Scriptable scope) {
            try {
                return this.resultRow.getFieldValue(OlapExpressionUtil.getAttrReference(this.dimName, this.key, value));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public void setCurrentKey(String key) {
            this.key = key;
        }

        public void setResultRow(IResultRow result) {
            this.resultRow = result;
        }

        public boolean isTimeDimLevel() {
            return this.resultRow.isTimeDimensionRow();
        }

        public List getLevelNames() {
            if (this.resultRow instanceof DimensionRowAccessor) {
                return ((DimensionRowAccessor)this.resultRow).getLevelNames();
            }
            return null;
        }
    }

    public static class InMatchDimensionIndicator
    extends RuntimeException {
        private static final long serialVersionUID = 1231475871896514362L;
    }
}

