/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class LibraryProvider
implements ILibraryProvider {
    private static final String MSG_OPEN_DEFINED_LIBRARY_ERROR_TITLE = Messages.getString((String)"LibraryProvider.openDefinedLibrary.error.dialog.title");
    private static final String MSG_OPEN_DEFINED_LIBRARY_ERROR_MSG = Messages.getString((String)"LibraryProvider.openDefinedLibrary.error.dialog.message");
    private List projectLibrarys;

    public LibraryHandle[] getLibraries() {
        this.projectLibrarys = new ArrayList();
        ArrayList libList = new ArrayList();
        try {
            libList.addAll(this.getProjectLibraryList());
        }
        catch (CoreException coreException) {}
        libList.addAll(this.getPreferenceLibraries(libList));
        return libList.toArray(new LibraryHandle[libList.size()]);
    }

    private ArrayList getProjectLibraryList() throws CoreException {
        IEditorPart editor = UIUtil.getActiveEditor((boolean)true);
        if (editor != null) {
            IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
            IProject project = file.getProject();
            IResource[] resources = project.members();
            return this.buildLibraryList(resources);
        }
        return null;
    }

    private ArrayList buildLibraryList(IResource[] resources) {
        ArrayList<LibraryHandle> libList = new ArrayList<LibraryHandle>();
        int i = 0;
        while (i < resources.length) {
            block8: {
                IResource resource = resources[i];
                if (resource.getType() == 1) {
                    LibraryHandle handle = null;
                    try {
                        handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(resource.getLocation().toOSString());
                    }
                    catch (Exception exception) {
                        break block8;
                    }
                    libList.add(handle);
                    this.projectLibrarys.add(handle.getFileName());
                } else if (resource.getType() == 2) {
                    try {
                        libList.addAll(this.buildLibraryList(((IFolder)resource).members()));
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++i;
        }
        return libList;
    }

    private ArrayList getPreferenceLibraries(ArrayList existList) {
        String[] predefinedLibrarys = ReportPlugin.getDefault().getLibraryPreference();
        ArrayList<LibraryHandle> libList = new ArrayList<LibraryHandle>();
        int i = 0;
        while (i < predefinedLibrarys.length) {
            try {
                LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(predefinedLibrarys[i]);
                if (!this.isLibExist(existList, handle)) {
                    libList.add(handle);
                }
            }
            catch (DesignFileException e) {
                ExceptionUtil.handle((Throwable)e, (String)MSG_OPEN_DEFINED_LIBRARY_ERROR_TITLE, (String)MSG_OPEN_DEFINED_LIBRARY_ERROR_MSG);
            }
            ++i;
        }
        return libList;
    }

    private boolean isLibExist(List list, LibraryHandle handle) {
        for (LibraryHandle element : list) {
            if (!element.getFileName().equals(handle.getFileName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInProjectFolder(LibraryHandle handle) {
        if (this.projectLibrarys == null) {
            return false;
        }
        return this.projectLibrarys.contains(handle.getFileName());
    }

    public Image getDisplayIcon(LibraryHandle handle) {
        if (!this.isInProjectFolder(handle)) {
            return ReportPlatformUIImages.getImage((String)"Library Referenced");
        }
        return null;
    }
}

