/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.GridHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.TreeViewer;

public class GridProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (((ReportElementHandle)object).isValidLayoutForCompoundElement()) {
            menu.add((IAction)new InsertAction(object, Messages.getString((String)"GridProvider.action.text"), "Row"));
        }
        super.createContextMenu(sourceViewer, object, menu);
    }

    public Object[] getChildren(Object object) {
        GridHandle gridHdl = (GridHandle)object;
        return this.getChildrenBySlotHandle(gridHdl.getRows());
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        Assert.isLegal((boolean)type.equals("Row"));
        GridHandleAdapter adapter = HandleAdapterFactory.getInstance().getGridHandleAdapter(model);
        if (slotHandle.getCount() > 0) {
            int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)slotHandle.get(slotHandle.getCount() - 1)).getRowNumber();
            adapter.insertRow(1, rowNumber);
        } else {
            adapter.insertRowInSlotHandle(slotHandle.getSlotID());
        }
        return true;
    }
}

