/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.widget.PopupSelectionList;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExpressionValueCellEditor
extends CellEditor {
    private static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    private transient ParamBindingHandle[] bindingParams = null;
    private transient String bindingName;
    private transient Text expressionText;
    private transient Button btnPopup;
    private transient ReportElementHandle currentItem = null;
    private transient String[] popupItems = null;
    private transient boolean refreshItems = true;
    private static String[] EMPTY_ARRAY = new String[0];
    private IExpressionProvider provider;

    public ExpressionValueCellEditor() {
    }

    public ExpressionValueCellEditor(Composite parent) {
        super(parent);
    }

    public ExpressionValueCellEditor(Composite parent, boolean useDataSetFilter) {
        super(parent);
    }

    public ExpressionValueCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, this.getStyle());
        editorComposite.setLayout((Layout)new ExpressionCellLayout());
        this.expressionText = new Text(editorComposite, 0);
        this.expressionText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExpressionValueCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.expressionText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.expressionText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.expressionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExpressionValueCellEditor.this.focusLost();
            }
        });
        this.btnPopup = new Button(editorComposite, 1028);
        this.btnPopup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionValueCellEditor.this.refreshList();
                Rectangle textBounds = ExpressionValueCellEditor.this.expressionText.getBounds();
                Point pt = ExpressionValueCellEditor.this.expressionText.toDisplay(textBounds.x, textBounds.y);
                Rectangle rect = new Rectangle(pt.x, pt.y, ((ExpressionValueCellEditor)ExpressionValueCellEditor.this).expressionText.getParent().getBounds().width, textBounds.height);
                PopupSelectionList popup = new PopupSelectionList(ExpressionValueCellEditor.this.expressionText.getParent().getShell());
                popup.setItems(ExpressionValueCellEditor.this.popupItems);
                String value = popup.open(rect);
                int selectionIndex = popup.getSelectionIndex();
                boolean returnValue = false;
                if (value != null) {
                    String newValue = null;
                    if (value.equals(actions[0])) {
                        if (ExpressionValueCellEditor.this.bindingName != null) {
                            try {
                                List selectValueList = ExpressionValueCellEditor.this.getSelectValueList();
                                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                                dialog.setSelectedValueList(selectValueList);
                                if (ExpressionValueCellEditor.this.bindingParams != null) {
                                    dialog.setBindingParams(ExpressionValueCellEditor.this.bindingParams);
                                }
                                if (dialog.open() == 0) {
                                    returnValue = true;
                                    newValue = dialog.getSelectedExprValue();
                                }
                            }
                            catch (Exception ex) {
                                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
                        }
                    } else if (value.equals(actions[1])) {
                        ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ExpressionValueCellEditor.this.getValue());
                        dialog.setExpressionProvier(ExpressionValueCellEditor.this.provider);
                        if (dialog.open() == 0) {
                            returnValue = true;
                            newValue = dialog.getResult();
                        }
                    } else if (selectionIndex > 3) {
                        newValue = ExpressionUtil.createJSParameterValueExpression((String)value);
                    }
                    if (returnValue) {
                        ExpressionValueCellEditor.this.setValue(DEUtil.resolveNull((String)newValue));
                    }
                    ExpressionValueCellEditor.this.expressionText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setValueValid(true);
        return editorComposite;
    }

    private List getSelectValueList() throws BirtException {
        ArrayList selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItem.getModuleHandle()));
            selectValueList.addAll(session.getColumnValueSet(reportItem.getDataSet(), reportItem.paramBindingsIterator(), reportItem.columnBindingsIterator(), this.bindingName));
            session.shutdown();
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    protected void focusLost() {
        if (this.btnPopup != null && !this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != this.btnPopup) {
            super.focusLost();
        }
    }

    protected Object doGetValue() {
        if (this.expressionText != null) {
            return this.expressionText.getText();
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.expressionText != null && this.expressionText.isVisible()) {
            this.expressionText.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (value != null && this.expressionText != null) {
            this.expressionText.setText(value.toString());
        }
    }

    public ParamBindingHandle[] getBindingParams() {
        return this.bindingParams;
    }

    public void setBindingParams(ParamBindingHandle[] bindingParams) {
        this.bindingParams = bindingParams;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            int n = 0;
            while (n < actions.length) {
                finalItems.add(actions[n]);
                ++n;
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    public void activate() {
        this.refreshItems = true;
        super.activate();
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        this.provider = provider;
    }

    private class ExpressionCellLayout
    extends Layout {
        private ExpressionCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            ExpressionValueCellEditor.this.expressionText.setBounds(0, 0, bounds.width - size.x, bounds.height);
            ExpressionValueCellEditor.this.btnPopup.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ExpressionValueCellEditor.this.expressionText.computeSize(-1, -1, force);
            Point buttonSize = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

