/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.factories;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.bpelactions.AbstractBPELAction;
import org.eclipse.bpel.ui.extensions.ActionDescriptor;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.extensions.UIObjectFactoryDescriptor;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.factories.ActionUIObjectFactory;
import org.eclipse.bpel.ui.factories.BPELUIObjectFactory;
import org.eclipse.bpel.ui.factories.IExtensionUIObjectFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;

public class UIObjectFactoryProvider {
    private static UIObjectFactoryProvider instance;
    protected Map<EClass, AbstractUIObjectFactory> eClass2factory = new HashMap<EClass, AbstractUIObjectFactory>();

    public static UIObjectFactoryProvider getInstance() {
        if (instance == null) {
            instance = new UIObjectFactoryProvider();
            UIObjectFactoryProvider.createUIObjectFactories(instance);
        }
        return instance;
    }

    protected static void createUIObjectFactories(UIObjectFactoryProvider provider) {
        EClass[] eClassArray = BPELUIObjectFactory.classArray;
        int n = BPELUIObjectFactory.classArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass modelType = eClassArray[n2];
            provider.register(modelType, new BPELUIObjectFactory(modelType));
            ++n2;
        }
        UIObjectFactoryDescriptor[] factories = BPELUIRegistry.getInstance().getUIObjectFactoryDescriptors();
        int i = 0;
        while (i < factories.length) {
            AbstractUIObjectFactory factory = factories[i].getFactory();
            EClass[] classArray = ((IExtensionUIObjectFactory)((Object)factory)).getClassArray();
            IConfigurationElement factConfigElement = factories[i].getConfigElement();
            int j = 0;
            while (j < classArray.length) {
                EClass modelType = classArray[j];
                IExtensionUIObjectFactory fact = null;
                try {
                    fact = (IExtensionUIObjectFactory)factConfigElement.createExecutableExtension("class");
                    fact.setModelType(modelType);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                provider.register(modelType, (AbstractUIObjectFactory)((Object)fact));
                ++j;
            }
            ++i;
        }
        ActionDescriptor[] actionDescriptorArray = BPELUIRegistry.getInstance().getActionDescriptors();
        int n3 = actionDescriptorArray.length;
        n = 0;
        while (n < n3) {
            ActionDescriptor descriptor = actionDescriptorArray[n];
            AbstractBPELAction action = descriptor.getAction();
            if (action != null) {
                provider.register(action.getModelType(), new ActionUIObjectFactory(action));
            }
            ++n;
        }
    }

    public AbstractUIObjectFactory getFactoryFor(EClass modelType) {
        return this.eClass2factory.get(modelType);
    }

    public void register(EClass modelType, AbstractUIObjectFactory factory) {
        Assert.isTrue((factory.getModelType() == modelType ? 1 : 0) != 0);
        this.eClass2factory.put(modelType, factory);
        if (Policy.DEBUG) {
            System.out.println("BPELUIObjectFactoryProvider registering EClass: " + modelType.getInstanceClassName());
        }
    }
}

