/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FileUtils {
    public static IFile getFile(URI uri) {
        if (uri == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String filePath = FileUtils.getWorkspaceFilePath(uri.trimFragment());
        if (filePath == null) {
            IPath location = Path.fromOSString((String)uri.toString());
            IFile file = workspaceRoot.getFileForLocation(location);
            if (file != null) {
                return file;
            }
            return null;
        }
        IResource workspaceResource = workspaceRoot.findMember(filePath);
        return (IFile)workspaceResource;
    }

    public static String getWorkspaceFilePath(URI uri) {
        if (uri.isPlatform()) {
            return uri.toPlatformString(true);
        }
        return null;
    }

    public static File createTempFile(String name) {
        return FileUtils.createTempFile(name, null);
    }

    public static File createTempFile(String name, InputStream istream) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(name, ".bpmn");
            if (istream != null) {
                FileOutputStream ostream = new FileOutputStream(tempFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while ((read = istream.read(bytes)) != -1) {
                    ((OutputStream)ostream).write(bytes, 0, read);
                }
                istream.close();
                ostream.flush();
                ((OutputStream)ostream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    public static String createTempName(String name) {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            tempDir = String.valueOf(tempDir) + File.separator;
        }
        String tempName = String.valueOf(tempDir) + name + "." + EcoreUtil.generateUUID();
        return tempName;
    }

    public static void deleteTempFile(URI uri) {
        File file = new File(uri.toFileString());
        if (file.exists()) {
            file.delete();
        }
    }

    public static boolean isTempFile(URI uri) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String uriDir = uri.trimFragment().trimSegments(1).devicePath();
        return tempDir != null && tempDir.compareToIgnoreCase(uriDir) == 0;
    }

    public static byte[] readStream(InputStream inputstream) throws IOException {
        byte[] bytes = null;
        int i = 0;
        byte[] tempBytes = new byte[1024];
        int j = inputstream.read(tempBytes);
        while (j != -1) {
            byte[] tempBytes2 = new byte[i + j];
            if (i > 0) {
                System.arraycopy(bytes, 0, tempBytes2, 0, i);
            }
            System.arraycopy(tempBytes, 0, tempBytes2, i, j);
            bytes = tempBytes2;
            i += j;
            j = inputstream.read(tempBytes);
        }
        return bytes;
    }
}

