/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.DirectEditBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.PropertyBasedFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.features.choreography.UpdateChoreographyMessageFlowFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class ChoreographyMessageLinkFeatureContainer
extends PropertyBasedFeatureContainer {
    protected String getPropertyKey() {
        return "choreography.messageLink";
    }

    protected boolean canApplyToProperty(String value) {
        return new Boolean(value);
    }

    public boolean canApplyTo(Object o) {
        if (super.canApplyTo(o)) {
            return true;
        }
        return o instanceof Connection && ChoreographyUtil.isChoreographyMessageLink((PictogramElement)((Connection)o));
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return null;
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return null;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return null;
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateChoreographyMessageFlowFeature(fp));
        return multiUpdate;
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditBaseElementFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new AbstractMoveShapeFeature(fp){

            public void moveShape(IMoveShapeContext context) {
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                return false;
            }
        };
    }

    public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IFeatureProvider fp) {
        return new DefaultMoveConnectionDecoratorFeature(fp){

            public boolean canMoveConnectionDecorator(IMoveConnectionDecoratorContext context) {
                return false;
            }

            public void moveConnectionDecorator(IMoveConnectionDecoratorContext context) {
            }
        };
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeShapeFeature(fp){

            public boolean canResizeShape(IResizeShapeContext context) {
                return false;
            }
        };
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DefaultDeleteBPMNShapeFeature(fp){

            public boolean canDelete(IDeleteContext context) {
                return context.getPictogramElement() instanceof ContainerShape;
            }

            public void delete(IDeleteContext context) {
                ContainerShape envelope = (ContainerShape)context.getPictogramElement();
                for (FixPointAnchor anchor : AnchorUtil.getAnchors((AnchorContainer)envelope)) {
                    this.modifyAffectedBands(anchor);
                }
                super.delete(context);
            }

            private void modifyAffectedBands(FixPointAnchor anchor) {
                for (Connection connection : anchor.getIncomingConnections()) {
                    ChoreographyActivity choreographyActivity;
                    AnchorContainer choreographyActivityShape = connection.getStart().getParent();
                    if (!(choreographyActivityShape instanceof ContainerShape) || (choreographyActivity = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyActivityShape, ChoreographyActivity.class)) == null) continue;
                    MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)connection);
                    List bands = FeatureSupport.getParticipantBandContainerShapes((ContainerShape)((ContainerShape)choreographyActivityShape));
                    Tuple topAndBottomBands = FeatureSupport.getTopAndBottomBands((List)bands);
                    List affectedBands = AnchorSite.getSite((FixPointAnchor)anchor) == AnchorSite.BOTTOM ? (List)topAndBottomBands.getFirst() : (List)topAndBottomBands.getSecond();
                    for (ContainerShape band : affectedBands) {
                        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
                        bpmnShape.setIsMessageVisible(false);
                    }
                    ChoreographyUtil.removeChoreographyMessageLink((PictogramElement)connection);
                    if (!(choreographyActivity instanceof ChoreographyTask)) break;
                    ChoreographyTask ct = (ChoreographyTask)choreographyActivity;
                    ct.getMessageFlowRef().remove(messageFlow);
                    UpdateContext updateContext = new UpdateContext((PictogramElement)choreographyActivityShape);
                    this.getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
                    break;
                }
            }
        };
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return null;
    }
}

