/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDeferredFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.core.resources.IResource;

public class UnusedSymbolInFileScopeChecker
extends AbstractIndexAstChecker {
    public static final String ER_UNUSED_VARIABLE_DECLARATION_ID = "org.eclipse.cdt.codan.internal.checkers.UnusedVariableDeclarationProblem";
    public static final String ER_UNUSED_FUNCTION_DECLARATION_ID = "org.eclipse.cdt.codan.internal.checkers.UnusedFunctionDeclarationProblem";
    public static final String ER_UNUSED_STATIC_FUNCTION_ID = "org.eclipse.cdt.codan.internal.checkers.UnusedStaticFunctionProblem";
    public static final String PARAM_MACRO_ID = "macro";
    public static final String PARAM_EXCEPT_ARG_LIST = "exceptions";
    private static final String[] ATTRIBUTE_UNUSED = new String[]{"__unused__", "unused"};
    private Map<IBinding, IASTDeclarator> externFunctionDeclarations = new HashMap<IBinding, IASTDeclarator>();
    private Map<IBinding, IASTDeclarator> staticFunctionDeclarations = new HashMap<IBinding, IASTDeclarator>();
    private Map<IBinding, IASTDeclarator> staticFunctionDefinitions = new HashMap<IBinding, IASTDeclarator>();
    private Map<IBinding, IASTDeclarator> externVariableDeclarations = new HashMap<IBinding, IASTDeclarator>();
    private Map<IBinding, IASTDeclarator> staticVariableDeclarations = new HashMap<IBinding, IASTDeclarator>();
    private IProblemWorkingCopy unusedVariableProblem = null;

    public boolean runInEditor() {
        return true;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_MACRO_ID, CheckersMessages.StatementHasNoEffectChecker_ParameterMacro, Boolean.TRUE);
        if (problem.getId().equals(ER_UNUSED_VARIABLE_DECLARATION_ID)) {
            this.unusedVariableProblem = problem;
            ListProblemPreference pref = this.addListPreference(problem, PARAM_EXCEPT_ARG_LIST, CheckersMessages.UnusedSymbolInFileScopeChecker_Exceptions, CheckersMessages.UnusedSymbolInFileScopeChecker_CharacterSequence);
            pref.addChildValue((Object)"@(#)");
            pref.addChildValue((Object)"$Id");
        }
    }

    private void clearCandidates() {
        this.externFunctionDeclarations.clear();
        this.staticFunctionDeclarations.clear();
        this.staticFunctionDefinitions.clear();
        this.externVariableDeclarations.clear();
        this.staticVariableDeclarations.clear();
    }

    private boolean isAnyCandidate() {
        return !this.externFunctionDeclarations.isEmpty() || !this.staticFunctionDeclarations.isEmpty() || !this.staticFunctionDefinitions.isEmpty() || !this.externVariableDeclarations.isEmpty() || !this.staticVariableDeclarations.isEmpty();
    }

    public void processAst(IASTTranslationUnit ast) {
        if (ast.isHeaderUnit()) {
            return;
        }
        this.clearCandidates();
        this.collectCandidates(ast);
        if (this.isAnyCandidate()) {
            this.filterOutUsedElements(ast);
            this.reportProblems();
        }
    }

    private void collectCandidates(IASTTranslationUnit ast) {
        try {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitDeclarations = true;
                }

                public int visit(IASTDeclaration element) {
                    IASTFunctionDefinition definition;
                    IASTFunctionDeclarator declarator;
                    IASTName astName;
                    if (element instanceof IASTSimpleDeclaration) {
                        IASTDeclarator[] declarators;
                        IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)element;
                        IASTDeclSpecifier declSpec = simpleDeclaration.getDeclSpecifier();
                        if (AttributeUtil.hasAttribute((IASTAttributeOwner)declSpec, (String[])ATTRIBUTE_UNUSED)) {
                            return 1;
                        }
                        IASTDeclarator[] iASTDeclaratorArray = declarators = simpleDeclaration.getDeclarators();
                        int n = declarators.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTName astName2;
                            IASTDeclarator decl = iASTDeclaratorArray[n2];
                            if (!AttributeUtil.hasAttribute((IASTAttributeOwner)decl, (String[])ATTRIBUTE_UNUSED) && (astName2 = decl.getName()) != null) {
                                IBinding binding = astName2.resolveBinding();
                                int storageClass = simpleDeclaration.getDeclSpecifier().getStorageClass();
                                if (binding instanceof IFunction) {
                                    if (storageClass == 2 || storageClass == 0) {
                                        if (UnusedSymbolInFileScopeChecker.this.shouldReportInMacro(UnusedSymbolInFileScopeChecker.ER_UNUSED_FUNCTION_DECLARATION_ID) || !CxxAstUtils.isInMacro((IASTNode)astName2)) {
                                            UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations.put(binding, decl);
                                        }
                                    } else if (storageClass == 3 && (UnusedSymbolInFileScopeChecker.this.shouldReportInMacro(UnusedSymbolInFileScopeChecker.ER_UNUSED_STATIC_FUNCTION_ID) || !CxxAstUtils.isInMacro((IASTNode)astName2))) {
                                        UnusedSymbolInFileScopeChecker.this.staticFunctionDeclarations.put(binding, decl);
                                    }
                                } else if (binding instanceof IVariable && (UnusedSymbolInFileScopeChecker.this.shouldReportInMacro(UnusedSymbolInFileScopeChecker.ER_UNUSED_VARIABLE_DECLARATION_ID) || !CxxAstUtils.isInMacro((IASTNode)astName2))) {
                                    IType type;
                                    if (storageClass == 2) {
                                        if (decl.getInitializer() == null) {
                                            UnusedSymbolInFileScopeChecker.this.externVariableDeclarations.put(binding, decl);
                                        }
                                    } else if (storageClass == 3 && !((type = ((IVariable)binding).getType()) instanceof ICPPClassType) && !(type instanceof IProblemType)) {
                                        IASTLiteralExpression literalExpression;
                                        String literal;
                                        ICPPASTConstructorInitializer constructorInitializer;
                                        IASTInitializerClause[] args;
                                        IASTInitializer initializer = decl.getInitializer();
                                        IASTInitializerClause clause = null;
                                        if (initializer instanceof IASTEqualsInitializer) {
                                            IASTEqualsInitializer equalsInitializer = (IASTEqualsInitializer)initializer;
                                            clause = equalsInitializer.getInitializerClause();
                                        } else if (initializer instanceof ICPPASTConstructorInitializer && (args = (constructorInitializer = (ICPPASTConstructorInitializer)initializer).getArguments()).length == 1) {
                                            clause = args[0];
                                        }
                                        if (!(clause instanceof IASTLiteralExpression) || !UnusedSymbolInFileScopeChecker.this.isFilteredOut(literal = (literalExpression = (IASTLiteralExpression)clause).toString(), (IProblem)UnusedSymbolInFileScopeChecker.this.unusedVariableProblem, UnusedSymbolInFileScopeChecker.PARAM_EXCEPT_ARG_LIST)) {
                                            UnusedSymbolInFileScopeChecker.this.staticVariableDeclarations.put(binding, decl);
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                        return 1;
                    }
                    if (element instanceof IASTFunctionDefinition && (astName = (declarator = (definition = (IASTFunctionDefinition)element).getDeclarator()).getName()) != null) {
                        IBinding binding = astName.resolveBinding();
                        if (definition.getDeclSpecifier().getStorageClass() == 3 && !(astName instanceof ICPPASTQualifiedName) && !AttributeUtil.hasAttribute((IASTAttributeOwner)declarator, (String[])ATTRIBUTE_UNUSED)) {
                            UnusedSymbolInFileScopeChecker.this.staticFunctionDefinitions.put(binding, declarator);
                        }
                        UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations.remove(binding);
                        UnusedSymbolInFileScopeChecker.this.staticFunctionDeclarations.remove(binding);
                    }
                    return 1;
                }
            });
        }
        catch (Exception e) {
            CodanCheckersActivator.log(e);
        }
    }

    private void filterOutUsedElements(IASTTranslationUnit ast) {
        try {
            ast.accept(new ASTVisitor(){
                {
                    this.shouldVisitNames = true;
                    this.shouldVisitDeclarations = true;
                }

                public int visit(IASTName name) {
                    IASTNode parentNode;
                    ICPPFunction[] candidates;
                    IBinding binding = name.resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        return 3;
                    }
                    if (binding instanceof IProblemBinding) {
                        String plainName = name.toString();
                        this.filterOutByPlainName(UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations, plainName);
                        this.filterOutByPlainName(UnusedSymbolInFileScopeChecker.this.staticFunctionDeclarations, plainName);
                        this.filterOutByPlainName(UnusedSymbolInFileScopeChecker.this.staticFunctionDefinitions, plainName);
                        this.filterOutByPlainName(UnusedSymbolInFileScopeChecker.this.externVariableDeclarations, plainName);
                        this.filterOutByPlainName(UnusedSymbolInFileScopeChecker.this.staticVariableDeclarations, plainName);
                    }
                    if (binding instanceof ICPPDeferredFunction && (candidates = ((ICPPDeferredFunction)binding).getCandidates()) != null) {
                        ICPPFunction[] iCPPFunctionArray = candidates;
                        int n = candidates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICPPFunction candidate = iCPPFunctionArray[n2];
                            UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations.remove(candidate);
                            UnusedSymbolInFileScopeChecker.this.staticFunctionDefinitions.remove(candidate);
                            ++n2;
                        }
                    }
                    if (!((parentNode = name.getParent()) instanceof IASTFunctionDefinition) && !(parentNode instanceof IASTFunctionDeclarator)) {
                        UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations.remove(binding);
                        UnusedSymbolInFileScopeChecker.this.staticFunctionDefinitions.remove(binding);
                    }
                    if (parentNode instanceof IASTDeclarator) {
                        if (((IASTDeclarator)parentNode).getInitializer() != null) {
                            UnusedSymbolInFileScopeChecker.this.externVariableDeclarations.remove(binding);
                        }
                    } else {
                        UnusedSymbolInFileScopeChecker.this.externVariableDeclarations.remove(binding);
                        UnusedSymbolInFileScopeChecker.this.staticVariableDeclarations.remove(binding);
                    }
                    if (!UnusedSymbolInFileScopeChecker.this.isAnyCandidate()) {
                        return 2;
                    }
                    return 3;
                }

                public int visit(IASTDeclaration declaration) {
                    if (declaration instanceof IASTASMDeclaration) {
                        String assembly = ((IASTASMDeclaration)declaration).getAssembly();
                        this.filterOutByAssembly(UnusedSymbolInFileScopeChecker.this.externFunctionDeclarations, assembly);
                        this.filterOutByAssembly(UnusedSymbolInFileScopeChecker.this.staticFunctionDeclarations, assembly);
                        this.filterOutByAssembly(UnusedSymbolInFileScopeChecker.this.staticFunctionDefinitions, assembly);
                        this.filterOutByAssembly(UnusedSymbolInFileScopeChecker.this.externVariableDeclarations, assembly);
                        this.filterOutByAssembly(UnusedSymbolInFileScopeChecker.this.staticVariableDeclarations, assembly);
                    }
                    if (!UnusedSymbolInFileScopeChecker.this.isAnyCandidate()) {
                        return 2;
                    }
                    return 3;
                }

                private void filterOutByAssembly(Map<IBinding, IASTDeclarator> declarators, String assembly) {
                    Iterator<Map.Entry<IBinding, IASTDeclarator>> iter = declarators.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<IBinding, IASTDeclarator> entry = iter.next();
                        IASTDeclarator decl = entry.getValue();
                        IASTName astName = UnusedSymbolInFileScopeChecker.this.getAstName(decl);
                        if (!assembly.contains(astName.toString())) continue;
                        iter.remove();
                    }
                }

                private void filterOutByPlainName(Map<IBinding, IASTDeclarator> declarators, String id) {
                    Iterator<Map.Entry<IBinding, IASTDeclarator>> iter = declarators.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<IBinding, IASTDeclarator> entry = iter.next();
                        IASTDeclarator decl = entry.getValue();
                        IASTName astName = UnusedSymbolInFileScopeChecker.this.getAstName(decl);
                        if (!id.equals(astName.toString())) continue;
                        iter.remove();
                    }
                }
            });
        }
        catch (Exception e) {
            CodanCheckersActivator.log(e);
        }
    }

    private IASTName getAstName(IASTDeclarator decl) {
        IASTName astName = null;
        do {
            if ((astName = decl.getName()) == null || astName.getSimpleID().length <= 0) continue;
            return astName;
        } while ((decl = decl.getNestedDeclarator()) != null);
        return astName;
    }

    private void reportProblems() {
        ArrayList<IASTDeclarator> funcDeclarators = new ArrayList<IASTDeclarator>();
        funcDeclarators.addAll(this.externFunctionDeclarations.values());
        funcDeclarators.addAll(this.staticFunctionDeclarations.values());
        for (IASTDeclarator symbol : funcDeclarators) {
            IASTName astName = this.getAstName(symbol);
            if (astName == null) continue;
            String symbolName = new String(astName.getSimpleID());
            this.reportProblem(ER_UNUSED_FUNCTION_DECLARATION_ID, (IASTNode)astName, new Object[]{symbolName});
        }
        ArrayList<IASTDeclarator> varDeclarators = new ArrayList<IASTDeclarator>();
        varDeclarators.addAll(this.externVariableDeclarations.values());
        varDeclarators.addAll(this.staticVariableDeclarations.values());
        for (IASTDeclarator symbol : varDeclarators) {
            IASTName astName = this.getAstName(symbol);
            if (astName == null) continue;
            String symbolName = new String(astName.getSimpleID());
            this.reportProblem(ER_UNUSED_VARIABLE_DECLARATION_ID, (IASTNode)astName, new Object[]{symbolName});
        }
        ArrayList<IASTDeclarator> staticFuncDeclarators = new ArrayList<IASTDeclarator>();
        staticFuncDeclarators.addAll(this.staticFunctionDefinitions.values());
        for (IASTDeclarator symbol : staticFuncDeclarators) {
            IASTName astName = this.getAstName(symbol);
            if (astName == null) continue;
            String symbolName = new String(astName.getSimpleID());
            this.reportProblem(ER_UNUSED_STATIC_FUNCTION_ID, (IASTNode)astName, new Object[]{symbolName});
        }
        this.clearCandidates();
    }

    private boolean isFilteredOut(String arg, IProblem problem, String exceptionListParamId) {
        Object[] arr = (Object[])this.getPreference(problem, exceptionListParamId);
        int i = 0;
        while (i < arr.length) {
            String str = (String)arr[i];
            if (arg.contains(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean shouldReportInMacro(String errorId) {
        return (Boolean)this.getPreference(this.getProblemById(errorId, (IResource)this.getFile()), PARAM_MACRO_ID);
    }
}

