/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag;

import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBagIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.bag.BagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionBag;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;

public interface Bag<T>
extends RichIterable<T> {
    public boolean equals(Object var1);

    public int hashCode();

    @Override
    public Bag<T> tap(Procedure<? super T> var1);

    @Override
    public Bag<T> select(Predicate<? super T> var1);

    @Override
    public <P> Bag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public Bag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> Bag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> Bag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> BagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> BagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public SetIterable<Pair<T, Integer>> zipWithIndex();

    public void forEachWithOccurrences(ObjectIntProcedure<? super T> var1);

    public int occurrencesOf(Object var1);

    public Bag<T> selectByOccurrences(IntPredicate var1);

    default public Bag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    default public SetIterable<T> selectUnique() {
        throw new UnsupportedOperationException("Adding default implementation so as to not break compatibility");
    }

    public ListIterable<ObjectIntPair<T>> topOccurrences(int var1);

    public ListIterable<ObjectIntPair<T>> bottomOccurrences(int var1);

    public int sizeDistinct();

    public MapIterable<T, Integer> toMapOfItemToCount();

    public String toStringOfItemToCount();

    public ImmutableBagIterable<T> toImmutable();

    @Override
    default public IntSummaryStatistics summarizeInt(IntFunction<? super T> function) {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEachWithOccurrences((each, occurrences) -> {
            int result = function.intValueOf(each);
            for (int i = 0; i < occurrences; ++i) {
                stats.accept(result);
            }
        });
        return stats;
    }

    @Override
    default public DoubleSummaryStatistics summarizeFloat(FloatFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.forEachWithOccurrences((each, occurrences) -> {
            float result = function.floatValueOf(each);
            for (int i = 0; i < occurrences; ++i) {
                stats.accept(result);
            }
        });
        return stats;
    }

    @Override
    default public LongSummaryStatistics summarizeLong(LongFunction<? super T> function) {
        LongSummaryStatistics stats = new LongSummaryStatistics();
        this.forEachWithOccurrences((each, occurrences) -> {
            long result = function.longValueOf(each);
            for (int i = 0; i < occurrences; ++i) {
                stats.accept(result);
            }
        });
        return stats;
    }

    @Override
    default public DoubleSummaryStatistics summarizeDouble(DoubleFunction<? super T> function) {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.forEachWithOccurrences((each, occurrences) -> {
            double result = function.doubleValueOf(each);
            for (int i = 0; i < occurrences; ++i) {
                stats.accept(result);
            }
        });
        return stats;
    }

    @Override
    default public <R, A> R reduceInPlace(Collector<? super T, A, R> collector) {
        Object mutableResult = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        this.forEachWithOccurrences((each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                accumulator.accept(mutableResult, (Object)each);
            }
        });
        return collector.finisher().apply(mutableResult);
    }

    @Override
    default public <R> R reduceInPlace(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        Object mutableResult = supplier.get();
        this.forEachWithOccurrences((each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                accumulator.accept(mutableResult, (Object)each);
            }
        });
        return mutableResult;
    }

    default public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        this.forEachWithOccurrences((each, occurrences) -> target.add(function.valueOf(each, occurrences)));
        return target;
    }
}

