/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.export.OutputterUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;

public class HTMLOutputter
extends AbstractOutputter {
    public void output(IResultSetObject resultset, Properties options, OutputStream stream) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, options.getProperty("encoding")));
        this.output(resultset, options, writer);
    }

    public void output(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        this.outputHTMLHeader(options, writer);
        this.outputHTMLContent(resultset, options, writer);
        this.outputHTMLFooter(writer);
    }

    public void output(IResultInstance rs, Properties props, OutputStream os) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, props.getProperty("encoding")));
        this.output(rs, props, writer);
    }

    public void output(IResultInstance rs, Properties props, PrintWriter pw) throws IOException {
        this.outputHTMLHeader(props, pw);
        int i = 0;
        while (i < rs.getItemCount()) {
            ResultItem item = rs.getItem(i);
            if (item != null && item.getResultObject() instanceof IResultSetObject) {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                this.outputHTMLContent(result, props, pw);
            }
            ++i;
        }
        this.outputHTMLFooter(pw);
    }

    private void outputHTMLHeader(Properties options, PrintWriter writer) {
        String encoding = options.getProperty("encoding");
        writer.println("<html>");
        writer.println("<head><meta content=\"text/html;charset=" + encoding + "\" /></head>");
        writer.println("<body>");
    }

    private void outputHTMLFooter(PrintWriter writer) {
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private void outputHTMLContent(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        String[] columnNames = resultset.getColumnNames();
        writer.println("<table border=\"1\">");
        writer.write("<tr>");
        int i = 0;
        while (i < columnNames.length) {
            writer.write("<th>");
            OutputterUtil.writeStringData(writer, columnNames[i]);
            writer.write("</th>");
            ++i;
        }
        writer.println("</tr>");
        Iterator iter = resultset.getAllRecords();
        while (iter != null && iter.hasNext()) {
            IResultSetRow rowData = (IResultSetRow)iter.next();
            this.outputHTMLContentColumn(rowData.getData(), options, writer);
        }
        iter = null;
        writer.println("</table>");
    }

    private void outputHTMLContentColumn(Object[] rowdata, Properties options, PrintWriter writer) throws IOException {
        writer.write("<tr>");
        int j = 0;
        while (j < rowdata.length) {
            writer.write("<td>");
            if (rowdata[j] == null) {
                String nullString = ResultsViewUIPlugin.getDefault().getPreferenceStore().getString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING);
                writer.write(nullString);
            } else if (rowdata[j] instanceof byte[]) {
                OutputterUtil.encodeCDATA(writer, (byte[])rowdata[j]);
            } else {
                OutputterUtil.writeStringData(writer, rowdata[j].toString());
            }
            writer.write("</td>");
            ++j;
        }
        writer.println("</tr>");
    }

    public void output(IResultSetObject rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }

    public void output(IResultInstance rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }
}

