/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.NamedMember;
import org.eclipse.dltk.internal.core.SourceMethodElementInfo;
import org.eclipse.dltk.utils.CorePrinter;

public class SourceMethod
extends NamedMember
implements IMethod {
    public SourceMethod(ModelElement parent, String name) {
        super(parent, name);
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceMethod)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String[] getParameterNames() throws ModelException {
        return ((SourceMethodElementInfo)this.getElementInfo()).getArgumentNames();
    }

    @Override
    public IParameter[] getParameters() throws ModelException {
        return ((SourceMethodElementInfo)this.getElementInfo()).getArguments();
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Source Method:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public boolean isConstructor() throws ModelException {
        return ((SourceMethodElementInfo)this.getElementInfo()).isConstructor();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public String getFullyQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException e) {
            return null;
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName("$");
    }

    @Override
    public IScriptFolder getScriptFolder() {
        IModelElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IScriptFolder)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    @Override
    public String getType() throws ModelException {
        return ((SourceMethodElementInfo)this.getElementInfo()).getReturnTypeName();
    }
}

